<?php $__env->startSection('title', 'Dashboard'); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('dist/css/hotspot/hotspot.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dist/css/hotspot/style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-6">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">Clients</h5>
                                <div class="col-4">
                                    <input type="month" lang="fr-CA" value="<?php echo e($year . '-' . $month); ?>"
                                        class="form-control" id="ClientDate">
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class='table table-striped' id="table1">
                                    <thead>
                                        <tr>
                                            <th scope="col">Client</th>

                                            <th scope="col">Matricule Fiscale</th>

                                            <th scope="col" id="number">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tableClients">

                                    </tbody>
                                </table>


                                <!--End Row-->



                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">Articles</h5>

                            </div>
                            <?php if($products && $products->count() > 0): ?>
                                <div id="carouselExample" class="carousel slide m-3">
                                    <div class="carousel-inner">
                                        <?php
                                            $smallestKey = $products->keys()->first();
                                        ?>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="carousel-item <?php echo e($key == $smallestKey ? 'active' : ''); ?>">
                                                <div class="d-flex flex-column justify-content-center align-items-center">
                                                    <div
                                                        class="col-12 d-flex flex-column flex-row p-2 justify-content-center">
                                                        <div
                                                            class="w-full d-flex flex-column justify-content-center align-items-center">
                                                            <?php if($product->image): ?>
                                                                <img style="max-height: 100px; max-width: 100px; object-fit: contain; padding: 3px; border-radius: 10%"
                                                                    src="<?php echo e(asset('/storage/products/' . $product->image)); ?>"
                                                                    alt="">
                                                            <?php else: ?>
                                                                <img style="max-height: 100px; max-width: 100px; object-fit: contain; padding: 3px; border-radius: 10%"
                                                                    src="<?php echo e(asset('static/2.png')); ?>" alt="">
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="mx-3 d-flex justify-content-center align-items-center">
                                                            <h5 class="card-title"><?php echo e($product->name); ?></h5>
                                                        </div>
                                                        <div class="mx-3 d-flex justify-content-center align-items-center">
                                                            Vendu(e):
                                                            <?php echo e($product->items->sum(function ($item) {
                                                                return $item->statement && $item->statement->type && $item->statement->type == 1 ? $item->quantity : 0;
                                                            })); ?>

                                                            fois
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                    <button class="carousel-control-prev" type="button" data-bs-target="#carouselExample"
                                        data-bs-slide="prev">
                                        <span class="carousel-control-prev-icon bg-primary rounded-circle"
                                            aria-hidden="true"></span>
                                        <span class="visually-hidden">Previous</span>
                                    </button>
                                    <button class="carousel-control-next" type="button" data-bs-target="#carouselExample"
                                        data-bs-slide="next">
                                        <span class="carousel-control-next-icon bg-primary rounded-circle"
                                            aria-hidden="true"></span>
                                        <span class="visually-hidden">Next</span>
                                    </button>
                                </div>
                            <?php else: ?>
                                <div class="d-flex justify-content-center m-3">
                                    <h5 class="card-title">Pas de Produits</h5>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>





    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="<?php echo e(asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('dist/js/vendors.js')); ?>"></script>

    <script>
        function getClients(month, year) {
            let url = "<?php echo e(route('dashboard.clients')); ?>";
            if (month) {
                url = url + "?month=" + month;
            }
            if (year) {
                url = url + "&year=" + year;
            }
            if (year && !month) {
                url = url + "?year=" + year;
            }
            axios.get(url).then(response => {
                let clients = response.data;
                let tableClients = document.getElementById('tableClients');
                tableClients.innerHTML = '';

                clients.forEach(client => {
                    let tr = document.createElement('tr');
                    let somme = 0;
                    somme += client.statements.reduce((acc, statement) => acc + statement.ttc, 0);
                    let path = "<?php echo e(asset('')); ?>";
                    tr.innerHTML = `
                    <td>
                        <div class="col-12 d-flex flex-row p-2 justify-content-start">
                            <div class="avatar avatar-sm">
                                <img src="${client.image ? path+'storage/clients/' + client.image : path+'static/1.jpg'}" alt="">
                            </div>
                            <div class="mx-3 d-flex justify-content-center align-items-center">
                                ${client.name}
                            </div>
                        </div>
                    </td>
                    <td>${client.matFisc ? client.matFisc : ""}</td>
                    <td>${parseFloat(somme).toFixed(3)} DT</td>
`;
                    tableClients.appendChild(tr);
                });
            });
        }
        getClients(null, null);

        document.getElementById('ClientDate').addEventListener('change', function(e) {

            let date = new Date(e.target.value);
            let month = date.getMonth() + 1;
            let year = date.getFullYear();
            getClients(month, year);
        });
    </script>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rjlbpor/www/resources/views/pages/dashboard/index.blade.php ENDPATH**/ ?>