@extends('welcome')
@section('title', 'Bons d\'entrées')
@section('styles')
    <link href="{{ asset('dist/css/hotspot/hotspot.css') }}" rel="stylesheet" />
    <link href="{{ asset('dist/css/hotspot/style.css') }}" rel="stylesheet" />
@endsection

@section('content')
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">
                                    @if ($bon)
                                        Modifier
                                    @else
                                        Ajouter
                                    @endif Un Bon d'entrée
                                </h5>
                                <div>
                                    <h5 class="card-title">
                                        @if ($bon)
                                            Élaborée par: {{ $bon->user->name }} {{ $bon->user->lastName }}
                                        @else
                                            Élaborée par: {{ auth()->user()->name }} {{ auth()->user()->lastName }}
                                        @endif
                                    </h5>
                                    <h5 class="card-title">
                                        @if ($bon)
                                            @if ($bon->edit_id != null)
                                                Modifiée par: {{ $bon->edit->name }} {{ $bon->edit->lastName }}
                                            @else
                                                Modifiée par: {{ auth()->user()->name }} {{ auth()->user()->lastName }}
                                            @endif
                                        @endif
                                    </h5>
                                </div>

                            </div>
                            <form method="POST" id="form" enctype="multipart/form-data"
                                action="{{ route('bon_d_entrees.store') }}">
                                @csrf
                                <div class="form-body">
                                    <div class="row">
                                        <div class="row mb-5">
                                            <div class="form-group col-md-3">
                                                <label>Référence: </label>
                                                <input type="text" name="reference" disabled id="reference"
                                                    style="font-weight: bold;"
                                                    @if ($bon) value="{{ $bon->reference }}" @else value="{{ $ref }}" @endif
                                                    class="form-control">
                                            </div>

                                            <div class="form-group col-md-3" id="clientDiv">
                                                <label>Fournisseur: </label>
                                                <select name="fournisseur" class="form-control" id="selectClients">
                                                    <option value="0" @if ($bon == null) selected @endif
                                                        disabled>--</option>
                                                    @foreach ($fournisseurs as $client)
                                                        <option @if ($bon && $bon->fournisseur == $client->id) selected @endif
                                                            value="{{ $client->id }}">
                                                            {{ $client->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>

                                            <div class="form-group col-md-3">
                                                <label>Facture: </label>
                                                <input type="text" name="facture"
                                                    @if ($bon) value="{{ $bon->facture }}" @endif
                                                    class="form-control">
                                            </div>

                                            <div class="form-group col-md-3">
                                                <label>Date: </label>
                                                <input type="Date" name="date"
                                                    @if ($bon) value="{{ $bon->date }}" @else value="{{ $date }}" @endif
                                                    class="form-control">
                                            </div>
                                        </div>
                                        <input type="hidden" id="productsInput" name="produits">
                                        <div class="form-group col-12">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <label>Code Article</label>
                                                    <div class="form-group" id="codeForm">
                                                        <select id="codeProducts" class="codeProducts form-control">
                                                            @foreach ($products as $product)
                                                                <option value="{{ $product->id }}">{{ $product->code }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3" id="searchForm">
                                                    <label>Articles</label>
                                                    <select id="selectProducts" class="selectProducts form-control">
                                                        @foreach ($products as $product)
                                                            <option value="{{ $product->id }}">{{ $product->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>

                                                <div class="col-md-3">
                                                    <label>Quantité</label>
                                                    <div class="form-group">
                                                        <input type="number" step="1" min="0"
                                                            id="quantitéProducts" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <label>Prix</label>
                                                    <div class="form-group">
                                                        <input type="number" step="0.001" min="0"
                                                            id="priceProducts" class="form-control">
                                                    </div>
                                                </div>

                                                <div class="col-md-3 mb-5"
                                                    @if (Auth::user()->role_id != 1) style="display: none;" @endif>
                                                    <label>&nbsp;</label> <!-- Placeholder for alignment -->
                                                    <div>
                                                        <button type="button" class="btn btn-primary w-full"
                                                            id="addProduct">Ajouter</button>
                                                    </div>
                                                    <div id="annuler"></div>
                                                </div>

                                            </div>

                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">Code</th>
                                                        <th scope="col">Article</th>
                                                        <th scope="col">Quantité</th>
                                                        <th scope="col">Prix</th>
                                                        @if (Auth::user()->role_id == 1)
                                                            <th scope="col">Actions</th>
                                                        @endif
                                                    </tr>
                                                </thead>
                                                <tbody id="tbody">

                                                </tbody>
                                            </table>
                                        </div>

                                        <div class="form-group col-12">
                                            <label>Commentaire: </label>
                                            <textarea name="comment" class="form-control" id="" cols="30" rows="3">{{ $bon ? $bon->comment : '' }}</textarea>
                                        </div>


                                        <div class="modal-footer"
                                            @if (Auth::user()->role_id != 1) style="display: none;" @endif>

                                            <button type="submit" class="btn btn-primary ml-1">
                                                <i class="bx bx-check d-block d-sm-none"></i>
                                                <span class="text-white">
                                                    @if ($bon)
                                                        Modifier
                                                    @else
                                                        Ajouter
                                                    @endif
                                                </span>
                                            </button>
                                        </div>


                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
@endsection

@section('scripts')

    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="{{ asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('dist/js/vendors.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.min.js"
        integrity="sha512-IOebNkvA/HZjMM7MxL0NYeLYEalloZ8ckak+NDtOViP7oiYzG5vn6WVXyrJDiJPhl4yRdmNAG49iuLmhkUdVsQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        let productSelectize;
        let codeSelectize;
        $(document).ready(function() {
            const items = [];
            const options = {
                persist: false,
                maxItems: 1,
                items: items,
                valueField: 'id',
                plugins: ["restore_on_backspace", "clear_button"],
                onChange: function(value) {

                    codeSelectize[0].selectize.setValue(value);
                }

            }

            const codeOptions = {
                persist: false,
                maxItems: 1,
                items: items,
                valueField: 'id',
                plugins: ["restore_on_backspace", "clear_button"],
                onChange: function(value) {
                    productSelectize[0].selectize.setValue(value);
                }

            }



            productSelectize = $('#selectProducts').selectize(options);
            codeSelectize = $('#codeProducts').selectize(codeOptions);

            $('#searchForm').find('.clear').each(function(index, button) {
                button.click();
            });
            $('#codeForm').find('.clear').each(function(index, button) {
                button.click();
            });

            const clientOptions = {
                persist: false,
                maxItems: 1,
                items: items,
                valueField: 'id',
                plugins: ["restore_on_backspace", "clear_button"],
            }
            const clientSelectize = $('#selectClients').selectize(clientOptions);

            $('#clientDiv').find('.clear').each(function(index, button) {
                button.click();
            });
            @if ($bon)
                const fournisseur = @json($bon->fournisseur);
                clientSelectize[0].selectize.setValue(fournisseur);
            @endif

        })
        @if ($bon)
            const products = @json(
                $bon->products->map(function ($product) {
                    return ['id' => $product->id, 'quantité' => $product->pivot->quantity, 'price' => $product->pivot->price];
                }));
        @else
            const products = [];
        @endif
        let index = 0;
        let update = false;
        const originalProducts = @json($products);
        const button = document.getElementById('addProduct');
        button.addEventListener('click', () => {
            if (update) {
                const select = document.getElementById('selectProducts');
                const quantité = document.getElementById('quantitéProducts');
                const price = document.getElementById('priceProducts');
                if (select.value == null || select.value == undefined || select.value == 0 || select.value == '') {
                    return;
                } else {
                    products[index] = {
                        id: select.value,
                        quantité: quantité.value,
                        price: price.value
                    };
                    select.value = 0;
                    quantité.value = 0;
                    price.value = 0;
                    $('#searchForm').find('.clear').each(function(index, button) {
                        button.click();
                    });
                    button.innerHTML = 'Ajouter';
                    update = false;
                    index = 0;
                    const annuler = document.getElementById('annuler');
                    annuler.innerHTML = '';
                    updateTable();
                }
            } else {
                const select = document.getElementById('selectProducts');
                const quantité = document.getElementById('quantitéProducts');
                const price = document.getElementById('priceProducts');

                if (select.value == null || select.value == undefined || select.value == 0 || select.value == '') {
                    return;
                } else {
                    products.push({
                        id: select.value,
                        quantité: quantité.value ? quantité.value : 0,
                        price: price.value ? price.value : 0
                    });
                    select.value = 0;
                    quantité.value = 0;
                    price.value = 0;
                    $('#searchForm').find('.clear').each(function(index, button) {
                        button.click();
                    });
                    updateTable();
                }
            }
        })

        function updateTable() {
            const tbody = document.getElementById('tbody');
            tbody.innerHTML = '';
            products.forEach((product) => {
                const p = originalProducts.find((p) => p.id == product.id);
                tbody.innerHTML += `
                    <tr id="p-${product.id}">
                        <td>${p.code == null ? "" : p.code}</td>
                        <td>${p.name}</td>
                        <td>${product.quantité}</td>
                        <td>${parseFloat(product.price).toFixed(3)}</td>
                        @if (Auth::user()->role_id == 1)
                        <td>
                            <button type="button" class="btn btn-warning" onclick="updateProduct('${product.id}','${product.quantité}','${product.price}')">Modifier</button>
                            <button type="button" class="btn btn-danger" onclick="removeProduct('p-${product.id}','${product.quantité}','${product.price}')">Supprimer</button>
                        </td>
                        @endif
                    </tr>
                `;
            })
        }
        updateTable();

        function removeProduct(id, quantité, prix) {
            const p_id = id.split('-')[1];
            const prod = products.find((p) => p.id == p_id && p.quantité == quantité && p.price == prix);
            const index = products.indexOf(prod);
            products.splice(index, 1);
            updateTable();
        }

        function updateProduct(id, quantity, prix) {
            const select = document.getElementById('selectProducts');
            const quantité = document.getElementById('quantitéProducts');
            const price = document.getElementById('priceProducts');
            const product = products.find((p) => p.id == id && p.quantité == quantity && p.price == prix);
            select.value = product.id;
            productSelectize[0].selectize.setValue(product.id);
            quantité.value = product.quantité;
            price.value = product.price;
            const annuler = document.getElementById('annuler');
            annuler.innerHTML = `<button type="button" class="btn btn-danger w-full" id="annulerProduct">Annuler</button>`;
            const annulerProduct = document.getElementById('annulerProduct');
            annulerProduct.addEventListener('click', () => {
                $('#searchForm').find('.clear').each(function(index, button) {
                    button.click();
                });
                select.value = 0;
                quantité.value = 0;
                price.value = 0;
                annuler.innerHTML = '';
                button.innerHTML = 'Ajouter';
                update = false;
                index = 0;
            })
            button.innerHTML = 'Modifier';
            update = true;
            index = products.indexOf(product);
        }


        const form = document.getElementById('form');
        form.addEventListener('submit', (e) => {
            e.preventDefault();
            @if ($bon)
                const action = `{{ route('bon_d_entrees.update', $bon->id) }}`;
                form.action = action;
            @endif
            const refInput = document.getElementById('reference');
            refInput.disabled = false;
            const productsInput = document.getElementById('productsInput');
            productsInput.value = JSON.stringify(products);
            form.submit();
        })
    </script>
@endsection
