<html>

<head>
    <meta charset="utf-8">
    <title><?php echo e($name); ?></title>
    <style>
        /* reset */

        * {
            border: 0;
            box-sizing: content-box;
            color: inherit;
            font-family: inherit;
            font-size: inherit;
            font-style: inherit;
            font-weight: inherit;
            line-height: inherit;
            list-style: none;
            margin: 0;
            padding: 0;
            text-decoration: none;
            vertical-align: top;
        }

        /* heading */

        h1 {
            font: bold 100% sans-serif;


            text-transform: uppercase;
        }

        h2 {
            font: bold 100% sans-serif;
            letter-spacing: 0.5em;
            text-align: center;
            text-transform: uppercase;
        }

        /* table */

        table {
            font-size: 75%;
            table-layout: fixed;
            width: 100%;
        }

        table {
            border-collapse: separate;
            border-spacing: 2px;
        }

        th,
        td {
            border-width: 1px;
            padding: 0.5em;
            position: relative;
            text-align: left;
        }

        th,
        td {
            border-radius: 0.25em;
            border-style: solid;
        }

        th {
            background: #EEE;
            border-color: #BBB;
        }

        td {
            border-color: #DDD;
        }

        /* page */

        html {
            font: 16px/1 'Open Sans', sans-serif;

            padding: 0.5in;

        }

        html {
            background: #999;
            cursor: default;
        }

        body {
            box-sizing: border-box;
            height: 11in;
            margin: 0 auto;

            padding: 0.5in;
            width: 7in;
        }

        body {
            background: #FFF;
            border-radius: 1px;
            box-shadow: 0 0 1in -0.25in rgba(0, 0, 0, 0.5);
        }

        /* header */

        header {
            margin: 0 0 2em;
            font-size: 150%;
            display: flex;
            flex-direction: row;
            justify-content: space-between;
        }

        header:after {
            clear: both;
            content: "";
            display: table;
        }

        header h1 {
            background: #000;
            border-radius: 10px;
            color: #FFF;
            margin: 0 0 1em;
            padding: 0.5em 0;
            text-align: center;
            letter-spacing: 1rem;
        }

        header address {

            font-size: 75%;
            font-style: normal;
            line-height: 1.25;
            margin: 0 1em 1em 0;
            display: flex;
            flex-direction: column;
            align-items: center;

        }

        header address p {
            margin: 0 0 0.25em;
        }

        .details {
            border-radius: 10px;
            border: 1px solid #000;
            padding: 0.5em 0.5em;
        }

        header img {
            margin-bottom: 10px;
        }


        header input {
            cursor: pointer;
            -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
            height: 100%;
            left: 0;
            opacity: 0;
            position: absolute;
            top: 0;
            width: 100%;
        }

        /* article */

        article,
        article address,
        table.meta,
        table.inventory {
            margin: 0 0 3em;
        }

        article:after {
            clear: both;
            content: "";
            display: table;
        }

        article h1 {
            clip: rect(0 0 0 0);
            position: absolute;
        }

        article address {


            font-size: 75%;
            font-style: normal;
            line-height: 1.25;
            margin: 0 1em 1em 0;

        }

        /* table meta & balance */

        table.meta,

        table.meta:after,
        table.balance:after {
            clear: both;
            content: "";
            display: table;
        }

        /* table meta */

        table.meta th {
            width: 40%;
        }

        table.meta td {
            width: 60%;
        }

        /* table items */

        table.inventory {
            clear: both;
            width: 100%;
        }

        table.inventory th {
            font-weight: bold;
            text-align: center;
        }


        /* table balance */

        table.balance th,
        table.balance td {
            width: 50%;
        }

        table.balance td {
            text-align: right;
        }

        /* aside */



        .pagenum:before {
            content: "Page " counter(page) " sur " counter(pages);
        }

        .pagenum {
            counter-increment: pages;
        }

        /* javascript */

        .add,
        .cut {
            border-width: 1px;
            display: block;
            font-size: .8rem;
            padding: 0.25em 0.5em;

            text-align: center;
            width: 0.6em;
        }



        @media print {
            * {
                -webkit-print-color-adjust: exact;
            }

            html {
                background: none;
                padding: 0;
            }

            body {
                box-shadow: none;
                margin: 0;
            }

            span:empty {
                display: none;
            }

            .add,
            .cut {
                display: none;
            }
        }

        @page {
            margin: 0;
            counter-reset: pages;
        }

        footer {
            position: fixed;
            bottom: 0%;
            font-size: 75%;
            font-style: normal;
            line-height: 1.25;
            margin: 0 1em 1em 0;
            width: 85%
        }

        footer hr {
            border: 0;
            border-top: 1px solid #000;
            margin-left: 0;
        }

        footer table {
            border-collapse: collapse;
        }

        footer th,
        footer td {
            font-size: 130%;
            border: none;

        }

        .custom-container {
            border-width: 0;
            padding: 0;
            display: flex;
            justify-content: flex-end;
            align-items: flex-end;
        }
    </style>
</head>

<body>
    <header>
        <table>
            <tr>
                <td style="border-width: 0px; padding: 0px">
                    <address style="width: 70%">
                        <img src="<?php echo e(public_path('static/' . $company->logo)); ?>" alt="Logo"
                            style="max-height: 150px; max-width:200px; object-fit:contain">

                    </address>

                </td>
                <td style="border-width: 0px; padding: 0px">
                    <address>

                        <?php if($client->image): ?>
                            <img src="<?php echo e(public_path('storage/clients/' . $client->image)); ?>" alt="Logo"
                                style="max-height: 150px; max-width:200px; object-fit:contain; float: right;">
                        <?php endif; ?>
                    </address>
                </td>
            </tr>
            <tr>
                <td style="border-width: 0px; padding: 0px">
                    <address style="width: 70%">
                        <div class="details">
                            <p><?php echo e($company->company); ?></p>
                            <p>Addresse: <?php echo e($company->address); ?></p>
                            <p>Téléphone: <?php echo e($company->phone); ?></p>
                            <p>Email: <?php echo e($company->email); ?></p>
                            <p>M.F: <?php echo e($company->matFisc); ?></p>
                        </div>
                    </address>

                </td>
                <td style="border-width: 0px; padding: 0px">
                    <address style="width: 70%; float: right;">
                        <div class="details">
                            <p><?php echo e($client->name); ?></p>
                            <p>Addresse:<?php echo e($client->address); ?></p>
                            <p>Téléphone:<?php echo e($client->tel); ?></p>
                            <p>Email:<?php echo e($client->email); ?></p>
                            <p>M.F:<?php echo e($client->matFisc); ?></p>
                        </div>

                    </address>
                </td>
            </tr>
            <tr>
                <td style="border-width: 0px; padding: 0px"></td>
                <td style="border-width: 0px; padding: 0px">
                    <table style="margin-top: 10px">
                        <tr>
                            <th>
                                <p>
                                    Bon De Livraison #
                                </p>
                            </th>
                            <td>
                                <p style="font-weight: bold;"><?php echo e($statement->reference); ?> </p>
                            </td>
                        </tr>
                        <tr>
                            <th>
                                <p>Date</p>
                            </th>
                            <td>
                                <p><?php echo e($date); ?></p>
                            </td>
                        </tr>

                    </table>
                </td>
            </tr>
        </table>
    </header>
    <article>


        <table class="inventory">
            <thead>

                <tr>
                    <th><span>Article</span></th>


                    <th><span>Quantité</span></th>

                </tr>

            </thead>
            <tbody>


                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="width: 75%">
                            <span style="display: inline-block">
                                <?php if($company->factimg && $list->image): ?>
                                    <img src="<?php echo e(public_path('storage/products/' . $list->image)); ?>"
                                        style="max-height: 50px; max-width:50px; object-fit: contain;" alt="">
                                <?php endif; ?>
                                <p style="margin-left: 3px; display: inline-block; ">
                                    <?php echo e($list->name != '' ? $list->name : $list->product); ?></p>
                            </span>
                        </td>
                        <td><span><?php echo e(sprintf('%.0f', $list->quantity)); ?></span></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>


    </article>


    <footer>
        <hr />
        <table>
            <tr>
                <td><?php echo e($date); ?></td>
                <td>RIB: <?php echo e($company->rib); ?> <?php echo e($company->bank); ?>, <?php echo e($company->agency); ?></td>
                <td><span class="pagenum" style="float: right"></span></td>
            </tr>
        </table>

    </footer>
</body>

</html>
<?php /**PATH /home/mrtechtndd/www/fact/resources/views/pdf/livraison.blade.php ENDPATH**/ ?>