<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BonDEntrees extends Model
{
    use HasFactory;

    public function products()
    {
        return $this->belongsToMany(Products::class, 'product_bon_d_entree', 'bon_id', 'product_id')->withPivot('quantity')->withPivot('price');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function edit()
    {
        return $this->belongsTo(User::class, 'edit_id', 'id');
    }

    public function fournisseurs()
    {
        return $this->belongsTo(Clients::class, 'fournisseur');
    }

    public function getId()
    {
        $length = 4;
        $upcomingId = intval(substr($this->reference, -4));
        $customID = strval($upcomingId + 1);
        $year = date('Y');
        $length = $length - strlen($customID);
        while ($length > 0) {
            $customID = substr_replace($customID, "0", 0, 0);
            $length = $length - 1;
        }
        $prefix = "BE";
        return $prefix  . $year . $customID;
    }
    protected $fillable = [
        'reference',
        'fournisseur',
        'facture',
        'comment',
        'date',
        'user_id',
        'edit_id',
    ];
}
