<?php

namespace App\Http\Controllers;

use App\Models\Products;
use Illuminate\Http\Request;

class ProductsController extends Controller
{
    public function index()
    {
        $products = Products::with('bon_d_entrees','items','items.statement')->get();
        return view('pages.products.index', ['products' => $products]);
    }

    public function store(Products $product)
    {
        $form_fields = request()->validate([
            'name' => 'required',
            'code' => 'nullable',
            'description' => 'nullable',
            'price' => 'nullable',
            'tva' => 'nullable',
        ]);
        if (request()->hasFile('image')) {
            $file = request()->file('image');
            $fileName =  $file->getClientOriginalName();
            if ($file->move(public_path() . '/storage/products/', $fileName)) {
                $form_fields['image'] = $fileName;
            }
        }
        $form_fields['quantity'] = 0;
        $product = Products::create($form_fields);
        return redirect()->back();
    }

    public function show($id)
    {
        $product = Products::findOrFail($id);
        return response()->json($product);
    }

    public function update($id, Request $request)
    {
        $product = Products::findOrFail($id);
        $form_fields = request()->validate([
            'name' => 'required',
            'code' => 'nullable',
            'description' => 'nullable',
            'price' => 'nullable',
            'tva' => 'nullable',
        ]);
        if (request()->hasFile('image')) {
            $file = request()->file('image');
            $fileName =  $file->getClientOriginalName();
            if ($file->move(public_path() . '/storage/products/', $fileName)) {
                $form_fields['image'] = $fileName;
            }
        } else {
            $form_fields['image'] = null;
        }
        $product->update($form_fields);
        return redirect()->back();
    }

    public function destroy($id)
    {
        $product = Products::findOrFail($id);
        $product->delete();
        return redirect()->back();
    }

}
