<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Statements extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */


    public function client()
    {
        return $this->belongsTo(Clients::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function edit()
    {
        return $this->belongsTo(User::class, 'edit_id', 'id');
    }

    public function items()
    {
        return $this->hasMany(StatementItems::class, 'statement_id', 'id');
    }

    public function getId()
    {
        $length = 4;
        $upcomingId = intval(substr($this->reference, -4));
        $customID = strval($upcomingId + 1);
        $year = date('Y');
        $length = $length - strlen($customID);
        while ($length > 0) {
            $customID = substr_replace($customID, "0", 0, 0);
            $length = $length - 1;
        }
        $prefix = "FA";
        if (($this->type == 2)) {
            $prefix = "DEV";
        } elseif (($this->type == 3)) {
            $prefix = "BL";
        }
        return $prefix . $year . $customID;
    }

    public function reglements()
    {
        return $this->hasMany(Reglement::class, 'statement_id', 'id');
    }

    public function statement()
    {
        return $this->belongsTo(Statements::class, 'statement_id', 'id');
    }

    protected $fillable = [
        'client_id',
        'timbreFiscal',
        'reference',
        'user_id',
        'edit_id',
        'tht',
        'ttc',
        'tva',
        'gqte',
        'type',
        'comment',
        'date',
        'is_generated',
        'statement_id',
    ];

    public function getBaseHtForTva($tvaRate)
    {
        return $this->items()
            ->where('tva', $tvaRate)
            ->sum(\DB::raw('(price * quantity) * (1 - discount / 100)'));
    }

    public function getTvaAmount($tvaRate)
    {
        $baseHt = $this->getBaseHtForTva($tvaRate);
        return $baseHt * ($tvaRate / 100);
    }
}
