<?php

namespace App\Http\Controllers;

use App\Models\Logs;
use App\Models\ModePaiment;
use Illuminate\Http\Request;


class ModePaimentController extends Controller
{
    public function index()
    {
        $types = ModePaiment::all()->sortByDesc('id');
        
            return view('pages.modes.list', [
                'types' => $types
            ]);
    }

    public function store(Request $request)
    {
        // dd($request);
        $formFields = $request->validate([
            'libelle' => ['required', 'string', 'max:255'],
        ]);
        $mode = ModePaiment::create($formFields);
        

        return redirect()->route('mode.index');
    }

    public function update(Request $request, $id)
    {

        $societe = ModePaiment::find($id);
        
        $request->validate([
            'libelle' => ['required', 'string', 'max:255'],
        ]);

        $societe->libelle = $request->input('libelle');
        $societe->update();
        
        return redirect()->back()->withSuccess('Type modifiée avec succès.');
    }


    public function destroy(ModePaiment $type)
    {   
        $type->delete();
        return redirect()->back()->withSuccess('Type supprimé avex succees!');
    }
}
