<?php $__env->startSection('title', 'Produits'); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('dist/css/hotspot/hotspot.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dist/css/hotspot/style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">Produits</h5>
                                <button type="button" data-bs-toggle="modal" data-bs-target="#inlineForm"
                                    class="btn btn-primary">Ajouter</button>
                            </div>
                            <div class="table-responsive">
                                <table class='table table-striped' id="table1">
                                    <thead>
                                        <tr>
                                            <th scope="col">Produit</th>
                                            <th scope="col">Description</th>
                                            <th scope="col">Prix</th>
                                            <th scope="col">Quantité</th>
                                            <th scope="col">TVA</th>
                                            <th scope="col">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <div class="col-12 d-flex flex-row p-2 justify-content-start">
                                                        <div class="avatar avatar-md">
                                                            <?php if($product->image): ?>
                                                                <img src=" <?php echo e(asset('/storage/products/' . $product->image)); ?>"
                                                                    alt="">
                                                            <?php else: ?>
                                                                <img src="<?php echo e(asset('static/2.png')); ?> " alt="">
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="mx-3 d-flex justify-content-center align-items-center">
                                                            <?php echo e($product->name); ?> </div>
                                                    </div>
                                                </td>
                                                <td><?php echo e($product->description); ?></td>

                                                <td><?php echo e($product->price); ?></td>
                                                <?php
                                                    $quantity = 0;
                                                    foreach ($product->bon_d_entrees as $bon) {
                                                        $quantity += $bon->pivot->quantity;
                                                    }
                                                    foreach ($product->items as $item) {
                                                        if ($item->statement->type == 1) {
                                                            $quantity -= $item->quantity;
                                                        }
                                                    }
                                                ?>
                                                <td><?php echo e($quantity); ?>

                                                </td>
                                                <td><?php echo e($product->tva); ?></td>

                                                <td>
                                                    <button id="<?php echo e($product->id); ?>" class="btn btn-warning edit"
                                                        data-bs-toggle="modal" data-bs-target="#inlineForm"><i
                                                            data-feather="edit"></i>Modifier</button>
                                                    <button onclick="deleteClient(<?php echo e($product->id); ?>)"
                                                        class="btn btn-danger"><i
                                                            data-feather="trash"></i>Supprimer</button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                                <form id="delete" method="POST">
                                    <?php echo method_field('DELETE'); ?>
                                    <?php echo csrf_field(); ?>

                                </form>
                                <!--End Row-->

                                <div class="modal fade text-left " id="inlineForm" tabindex="-1" role="dialog"
                                    aria-labelledby="myModalLabel33" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-scrollable" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="myModalLabel33">Ajouter </h4>
                                                <button type="button" class="close" data-bs-dismiss="modal"
                                                    aria-label="Close">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
                                                        <path
                                                            d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                                    </svg>
                                                </button>
                                            </div>
                                            <form method="POST" action="<?php echo e(route('products.store')); ?>"
                                                enctype="multipart/form-data" id="formmm">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">
                                                    <label>Nom: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="name" class="form-control">
                                                    </div>


                                                    <label>Description: </label>
                                                    <div class="form-group">
                                                        <textarea name="description" class="form-control" id="" cols="30" rows="10"></textarea>
                                                    </div>

                                                    <label>Prix: </label>
                                                    <div class="form-group">
                                                        <input type="number" name="price" step="0.01"
                                                            class="form-control">
                                                    </div>

                                                    <label>TVA: </label>
                                                    <div class="form-group">
                                                        <input type="number" name="tva" step="0.01"
                                                            class="form-control">

                                                        <label>Image: </label>
                                                        <input type="file" name="image"
                                                            class="multiple-files-filepond">
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-light-secondary"
                                                            data-bs-dismiss="modal">
                                                            <i class="bx bx-x d-block d-sm-none"></i>
                                                            <span class="d-none d-sm-block">Annuler</span>
                                                        </button>
                                                        <button type="submit" class="btn btn-primary ml-1">
                                                            <i class="bx bx-check d-block d-sm-none"></i>
                                                            <span class="d-none d-sm-block text-white">Ajouter</span>
                                                        </button>
                                                    </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>



        </div>
        <!--End Row-->



        <!--start overlay-->
        <div class="overlay toggle-menu"></div>
        <!--end overlay-->
    </div>
    <!-- End container-fluid-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>


    <script src="<?php echo e(asset('dist/js/simple-datatables/simple-datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('dist/js/vendors.js')); ?>"></script>
    <script>
        const pond = FilePond.create(document.querySelector(".multiple-files-filepond"), {
            credits: null,
            allowImagePreview: true,
            allowImageFilter: false,
            allowImageExifOrientation: false,
            allowMultiple: false,
            required: false,
            storeAsFile: true,
            acceptedFileTypes: ["image/png", "image/jpg", "image/jpeg"],
            labelIdle: `<span class="text-primary">Choisir une image ou <span class="filepond--label-action text-primary" >Browse</span></span>`,
        });



        function deleteClient(id) {
            var form = document.getElementById('delete');
            let base = "<?php echo e(route('products.destroy', '5')); ?>";
            base = base.replace('5', id);
            form.action = base;
            form.submit();
        }

        document.addEventListener('click', function(event) {
            const target = event.target;
            if (target.classList.contains('edit')) {
                const form = document.getElementById('formmm');
                const editButton = target;
                const id = editButton.id;
                let base = "<?php echo e(route('products.show', '5')); ?>".replace('5', id);
                const nameInput = form.querySelector('input[name="name"]');
                const descriptionInput = form.querySelector('textarea[name="description"]');
                const priceInput = form.querySelector('input[name="price"]');
                const tvaInput = form.querySelector('input[name="tva"]');
                const imageInput = form.querySelector('input[name="image"]');

                axios.get(base).then((response) => {
                    const product = response.data;
                    nameInput.value = product.name;
                    descriptionInput.value = product.description;
                    priceInput.value = product.price;
                    tvaInput.value = product.tva;
                    if (product.image) {
                        pond.addFile("<?php echo e(route('home')); ?>/storage/products/" + product.image);
                    }


                    form.action = "<?php echo e(route('products.update', '5')); ?>".replace('5', id);
                });
            }
        });

        const clearInput = () => {
            const form = document.getElementById('formmm');
            const nameInput = form.querySelector('input[name="name"]');
            const descriptionInput = form.querySelector('textarea[name="description"]');
            const priceInput = form.querySelector('input[name="price"]');
            const tvaInput = form.querySelector('input[name="tva"]');
            const imageInput = form.querySelector('input[name="image"]');

            nameInput.value = "";
            descriptionInput.value = "";
            priceInput.value = 0;
            tvaInput.value = 0;
            pond.removeFile();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ahmed/facture/ap/resources/views/pages/products/index.blade.php ENDPATH**/ ?>