<?php $__env->startSection('title'); ?>
    <?php if($type == 1): ?>
        Factures
    <?php endif; ?>
    <?php if($type == 2): ?>
        Devis
    <?php endif; ?>
    <?php if($type == 3): ?>
        Bons de livraisons
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('dist/css/hotspot/hotspot.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dist/css/hotspot/style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">
                                    <?php if($type == 1): ?>
                                        Factures
                                    <?php endif; ?>
                                    <?php if($type == 2): ?>
                                        Devis
                                    <?php endif; ?>
                                    <?php if($type == 3): ?>
                                        Bons De Livraisons
                                    <?php endif; ?>
                                </h5>
                                <button type="button" class="btn btn-primary" onclick="rediretionButton()">Ajouter</button>
                            </div>
                            <div class="row">
                                <?php if($type == 1): ?>
                                    <div class="d-flex flex-wrap justify-content-center align-items-end mb-3">
                                        <div class="w-25 m-1" style="min-width: 250px">
                                            <label>Client: </label>
                                            <div class="form-group">
                                                <select class="form-control" name="clientSearch" id="clientSearch">
                                                    <option value="">Tous</option>
                                                    <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="w-25 m-1" style="min-width: 250px">
                                            <label>Date de début: </label>
                                            <div class="form-group">
                                                <input type="date" name="date_debut" id="date_debut"
                                                    class="form-control">
                                            </div>
                                        </div>
                                        <div class="w-25 m-1" style="min-width: 250px">
                                            <label>Date de fin: </label>
                                            <div class="form-group">
                                                <input type="date" name="date_fin" id="date_fin" class="form-control" >
                                            </div>
                                        </div>
                                        <div class="w-25 m-1" style="min-width: 250px">
                                            <button class="btn btn-primary" id="dateFilter">
                                                Filtrer
                                            </button>
                                            <a class="btn btn-secondary" href="<?php echo e(route('invoices.index')); ?>">
                                                Réinitialiser
                                            </a>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="table-responsive">
                                    <table class='table table-striped <?php if($type == 1): ?> sum <?php endif; ?>'
                                        id="table1">
                                        <thead>
                                            <tr>
                                                <?php if($type != 1): ?>
                                                    <th class="noExport" id="actions"></th>
                                                <?php endif; ?>
                                                <th id="date" scope="col">Date</th>
                                                <th scope="col">Référence</th>
                                                <th scope="col">Client</th>
                                                <th id="number" scope="col">Quantité Générale</th>
                                                <?php if($type != 3): ?>
                                                    <th id="number" class="summable montant" scope="col">THT</th>
                                                    <th id="number" class="summable montant" scope="col">TTC</th>
                                                <?php endif; ?>
                                                <?php if($type == 1): ?>
                                                    <th id="status" scope="col">Statut</th>
                                                <?php endif; ?>
                                                <th scope="col">Commentaire</th>
                                                <th scope="col">Ajouté Par</th>
                                                <th scope="col">Modifié Par</th>
                                                <?php if($type == 3): ?>
                                                    <th scope="col">Référence Facture</th>
                                                <?php endif; ?>
                                                <th id="actions" class="noExport" scope="col">PDF</th>
                                                <th scope="col" class="noExport">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $statements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <?php if($type != 1): ?>
                                                        <td>
                                                            <?php if(($statement->type == 3 && $statement->is_generated == 0) || $statement->type == 2): ?>
                                                                <input type="checkbox" class="multiCheckbox" name="check[]"
                                                                    id="<?php echo e($statement->id); ?>">
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                    <td><?php echo e($statement->date ? date_create($statement->date)->format('d-m-Y') : $statement->created_at->format('d-m-Y')); ?>

                                                    </td>
                                                    <td class="fw-bolder"><?php echo e($statement->reference); ?></td>
                                                    <td><?php echo e($statement->client->name); ?></td>
                                                    <td><?php echo e(sprintf('%.0f', $statement->gqte)); ?></td>
                                                    <?php if($type != 3): ?>
                                                        <td><?php echo e(sprintf('%.3f', $statement->tht)); ?> DT</td>
                                                        <td><?php echo e(sprintf('%.3f', $statement->ttc)); ?> DT</td>
                                                    <?php endif; ?>
                                                    <?php if($type == 1): ?>
                                                        <td>
                                                            <?php if($statement->reglements->where('statut', 1)->sum('montant') < $statement->ttc): ?>
                                                                <span class="badge bg-danger">⦾ Non Payé</span>
                                                            <?php else: ?>
                                                                <span class="badge bg-success">⦿ Payé</span>
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                    <td><?php echo e($statement->comment); ?></td>
                                                    <td><?php echo e($statement->user != null ? $statement->user->name . ' ' . $statement->user->lastName : ''); ?>

                                                    </td>
                                                    <td><?php echo e($statement->edit != null ? $statement->edit->name . ' ' . $statement->edit->lastName : ''); ?>

                                                    </td>
                                                    <?php if($type == 3): ?>
                                                        <td>
                                                            <?php if($statement->is_generated): ?>
                                                                <a
                                                                    href="<?php echo e(route('invoices.show', $statement->statement->id)); ?>"><?php echo e($statement->statement->reference); ?></a>
                                                            <?php else: ?>
                                                                Non Générée
                                                            <?php endif; ?>
                                                        </td>
                                                    <?php endif; ?>
                                                    <td>
                                                        <?php if($type == 3): ?>
                                                            <a target="_blank"
                                                                href="<?php echo e(route('statements.delivery', $statement->id)); ?>"
                                                                class="btn btn-success">Imprimer</a>
                                                        <?php else: ?>
                                                            <a target="_blank"
                                                                href="<?php echo e(route('statements.getPDF', $statement->id)); ?>"
                                                                class="btn btn-success">Imprimer</a>
                                                        <?php endif; ?>
                                                    <td>
                                                        <?php if($type != 1): ?>
                                                            <?php if(($statement->type == 3 && $statement->is_generated == 0) || $statement->type == 2): ?>
                                                                <a href="<?php echo e(route('statements.toInvoice', $statement->id)); ?>"
                                                                    class="btn btn-primary"><i
                                                                        data-feather="eye"></i>Générer
                                                                    une
                                                                    Facture</a>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                        <?php if($type == 1): ?>
                                                            <a href="<?php echo e(route('statements.toBon', $statement->id)); ?>"
                                                                class="btn btn-primary">Générer un bon de livraison</a>
                                                        <?php endif; ?>
                                                        <button id="<?php echo e($statement->id); ?>" class="btn btn-warning edit"><i
                                                                data-feather="edit"></i>Modifier</button>

                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                        <?php if($type == 1): ?>
                                            <tfoot>
                                                <?php if($type != 1): ?>
                                                    <th style="color:#ff0000"></th>
                                                <?php endif; ?>
                                                <th style="color:#ff0000">Somme:</th>
                                                <th style="color:#ff0000"></th>
                                                <th style="color:#ff0000"></th>
                                                <th style="color:#ff0000"></th>
                                                <?php if($type != 3): ?>
                                                    <th style="color:#ff0000"></th>
                                                    <th style="color:#ff0000"></th>
                                                <?php endif; ?>
                                                <?php if($type == 1): ?>
                                                    <th style="color:#ff0000"></th>
                                                <?php endif; ?>
                                                <th style="color:#ff0000"></th>
                                                <?php if($type == 3): ?>
                                                    <th style="color:#ff0000"></th>
                                                <?php endif; ?>
                                                <th style="color:#ff0000"></th>
                                                <th style="color:#ff0000"></th>
                                            </tfoot>
                                        <?php endif; ?>
                                    </table>
                                </div>
                                <form id="delete" method="POST">
                                    <?php echo method_field('DELETE'); ?>
                                    <?php echo csrf_field(); ?>

                                </form>

                                <!--End Row-->

                            </div>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
    <div class="content-wrapper d-none" id="generateMulti">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-end">
                                <button type="button" class="btn btn-primary" onclick="generateMultiButton()">
                                    Générer une facture
                                </button>
                            </div>
                        </div>
                        <div class="modal modal-xl fade text-left " id="inlineForm" tabindex="-1" role="dialog"
                            aria-labelledby="myModalLabel33" aria-hidden="true">
                            <div class="modal-dialog modal-dialog-scrollable" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title" id="myModalLabel33">Confirmer </h4>
                                        <button type="button" class="close" data-bs-dismiss="modal"
                                            aria-label="Close">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
                                                <path
                                                    d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                            </svg>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div id="alerts">
                                            <div class="alert alert-warning">This is warning alert.</div>
                                        </div>
                                        <div class="table-responsive">
                                            <table class='table table-striped' id="table1">
                                                <thead>
                                                    <tr>

                                                        <th id="date" scope="col">Date</th>
                                                        <th scope="col">Référence</th>
                                                        <th scope="col">Client</th>
                                                        <th id="number" scope="col">Quantité Générale</th>
                                                        <th scope="col">Commentaire</th>
                                                        <th id="actions"></th>
                                                    </tr>
                                                </thead>
                                                <tbody id="confirmMulti">
                                                </tbody>
                                            </table>

                                        </div>
                                        <div id="successDiv" class="mt-3">
                                            <div class="alert alert-success">This is warning alert.</div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary"
                                            data-bs-dismiss="modal">Annuler</button>
                                        <button type="button" class="btn btn-primary" id="generateMultiButtonConfirm"
                                            onclick="generateMultiRequest()">Confirmer</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="<?php echo e(asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <?php if($type == 1): ?>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/dataTables.buttons.min.js"></script>
        <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/1.3.1/js/buttons.html5.min.js"></script>
        <script type="text/javascript" src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.colVis.min.js"></script>
    <?php endif; ?>
    <script src="<?php echo e(asset('dist/js/vendors.js')); ?>"></script>



    <script>
        function deleteClient(id) {
            var form = document.getElementById('delete');
            let base = "<?php echo e(route('statements.destroy', '5')); ?>";
            base = base.replace('5', id);
            form.action = base;
            form.submit();
        }

        document.addEventListener('click', function(event) {
            const target = event.target;
            if (target.classList.contains('edit')) {
                const editButton = target;
                const id = editButton.id;
                <?php if($type == 1): ?>
                    window.location.href = "<?php echo e(route('invoices.show', '5')); ?>".replace('5', id);
                <?php endif; ?>
                <?php if($type == 2): ?>
                    window.location.href = "<?php echo e(route('statements.show', '5')); ?>".replace('5', id);
                <?php endif; ?>
                <?php if($type == 3): ?>
                    window.location.href = "<?php echo e(route('bons.show', '5')); ?>".replace('5', id);
                <?php endif; ?>
            }
        })



        function rediretionButton() {
            <?php if($type == 1): ?>
                window.location.href = "<?php echo e(route('invoices.show')); ?>"
            <?php endif; ?>
            <?php if($type == 2): ?>
                window.location.href = "<?php echo e(route('statements.show')); ?>"
            <?php endif; ?>
            <?php if($type == 3): ?>
                window.location.href = "<?php echo e(route('bons.show')); ?>"
            <?php endif; ?>

        }

        localStorage.setItem('ids', "[]");
        $(document).ready(function() {
            $('.multiCheckbox').each(function() {
                $(this).on('click', function() {
                    if ($('.multiCheckbox:checked').length > 0) {
                        $('#generateMulti').removeClass('d-none');
                    } else {
                        $('#generateMulti').addClass('d-none');
                    }
                    if ($(this).is(':checked')) {
                        $(this).closest('tr').addClass('selected');
                        let ids = localStorage.getItem('ids');
                        if (ids && Array.isArray(JSON.parse(ids))) {
                            ids = JSON.parse(ids);
                            ids.push($(this).attr('id'));
                        } else {
                            ids = [];
                            ids.push($(this).attr('id'));
                        }
                        localStorage.setItem('ids', JSON.stringify(ids));
                    } else {
                        $(this).closest('tr').removeClass('selected');
                        let ids = localStorage.getItem('ids');
                        if (ids && Array.isArray(JSON.parse(ids))) {
                            ids = JSON.parse(ids);
                            ids = ids.filter((id) => id != $(this).attr('id'));
                        }
                        localStorage.setItem('ids', JSON.stringify(ids));
                    }
                });

                $(this).closest('tr').on('click', function(e) {
                    if (e.target.tagName.toLowerCase() != 'input') {
                        if ($(this).find('.multiCheckbox').is(':checked')) {
                            $(this).find('.multiCheckbox').prop('checked', false);
                            $(this).removeClass('selected');
                            let ids = localStorage.getItem('ids');
                            if (ids && Array.isArray(JSON.parse(ids))) {
                                ids = JSON.parse(ids);
                                ids = ids.filter((id) => id != $(this).find('.multiCheckbox').attr(
                                    'id'));
                            }
                            localStorage.setItem('ids', JSON.stringify(ids));
                        } else {
                            $(this).find('.multiCheckbox').prop('checked', true);
                            $(this).addClass('selected');
                            let ids = localStorage.getItem('ids');
                            if (ids && Array.isArray(JSON.parse(ids))) {
                                ids = JSON.parse(ids);
                                ids.push($(this).find('.multiCheckbox').attr('id'));
                            } else {
                                ids = [];
                                ids.push($(this).find('.multiCheckbox').attr('id'));
                            }
                            localStorage.setItem('ids', JSON.stringify(ids));
                        }
                        if ($('.multiCheckbox:checked').length > 0) {
                            $('#generateMulti').removeClass('d-none');
                        } else {
                            $('#generateMulti').addClass('d-none');
                        }
                    }
                });
            });
        })


        const statements = <?php echo json_encode($statements, 15, 512) ?>;

        function generateMultiButton() {
            let ids = localStorage.getItem('ids');
            let client_id = null;

            if (ids && Array.isArray(JSON.parse(ids))) {
                ids = JSON.parse(ids);
                let confirmMulti = document.getElementById('confirmMulti');
                confirmMulti.innerHTML = '';

                ids.forEach((id) => {
                    const statement = statements.find((s) => s.id == id);

                    // Extracted function call
                    displayAlert();

                    client_id = statement.client_id;

                    const date = new Date(statement.created_at);
                    const day = String(date.getDate()).padStart(2, '0');
                    const month = String(date.getMonth() + 1).padStart(2, '0');
                    const year = date.getFullYear();

                    confirmMulti.innerHTML += `
                <tr>
                    <td>${day}-${month}-${year}</td>
                    <td>${statement.reference}</td>
                    <td>${statement.client.name}</td>
                    <td>${statement.gqte}</td>
                    <td>${statement.comment != null ? statement.comment : ""}</td>
                    <td><button class="btn btn-danger removeButton" id="${id}">Retirer</button></td>
                </tr>
            `;
                });

                $('#inlineForm').modal('show');

                $(".removeButton").each(function() {
                    $(this).on('click', function() {
                        let ids = localStorage.getItem('ids');
                        if (ids && Array.isArray(JSON.parse(ids))) {
                            ids = JSON.parse(ids);
                            ids = ids.filter((id) => id != $(this).attr('id'));
                        }
                        localStorage.setItem('ids', JSON.stringify(ids));
                        $(this).closest('tr').remove();
                        if ($('.multiCheckbox:checked').length > 0) {
                            // get the checkbox with the id of the button
                            let id = $(this).attr('id');
                            let checkbox = $("input[type='checkbox']#" + id);
                            checkbox.prop('checked', false);
                            checkbox.closest('tr').removeClass('selected');
                        }

                        // Extracted function call
                        displayAlert();
                    });
                });
            }
        }

        // Extracted function for displaying alerts
        function displayAlert() {

            let ids = localStorage.getItem('ids');
            let client_id = null;

            if (ids && Array.isArray(JSON.parse(ids))) {
                ids = JSON.parse(ids);
                const statementsObject = {};
                ids.forEach((id) => {
                    const statement = statements.find((s) => s.id == id);
                    statementsObject[statement.client_id] = statement;
                });

                if (ids.length == 0) {
                    const type = <?php echo json_encode($type, 15, 512) ?>;
                    $("#alerts").html(
                        `<div class="alert alert-danger">Séléctionner des ${type==3?"bons de livraisons":type==2?"devis":""} </div>`
                    );
                    $("#successDiv").html('');
                    $("#generateMultiButtonConfirm").prop('disabled', true);
                    $("#generateMultiButtonConfirm").removeClass('btn-primary');
                } else {
                    $("#successDiv").html('<div class="alert alert-success">Vous pouvez générer votre facture</div>');
                    $("#alerts").html('');
                    $("#generateMultiButtonConfirm").prop('disabled', false);
                    $("#generateMultiButtonConfirm").addClass('btn-primary');
                    if (Object.keys(statementsObject).length > 1) {
                        $("#successDiv").html('');
                        $("#alerts").html(
                            `<div class="alert alert-danger">Vous ne pouvez pas générer une facture pour des clients différents</div>`
                        );
                        $("#generateMultiButtonConfirm").prop('disabled', true);
                        $("#generateMultiButtonConfirm").removeClass('btn-primary');
                    } else {
                        $("#alerts").html('');
                        $("#successDiv").html('<div class="alert alert-success">Vous pouvez générer votre facture</div>');
                        $("#generateMultiButtonConfirm").prop('disabled', false);
                        $("#generateMultiButtonConfirm").addClass('btn-primary');
                    }
                }
            }

        }

        function generateMultiRequest() {
            let ids = localStorage.getItem('ids');
            if (ids && Array.isArray(JSON.parse(ids))) {
                ids = JSON.parse(ids);
                axios.post("<?php echo e(route('statements.generate')); ?>", {
                    ids: ids
                }).then((response) => {
                    if (response.data.success) {
                        localStorage.setItem('ids', "[]");
                        // url = response.data.;
                    }
                }).catch((error) => {
                    console.log(error);
                }).finally(() => {
                    window.location.href = "<?php echo e(route('invoices.index')); ?>";
                });
            }
        }

        <?php if($type == 1): ?>
            document.getElementById("dateFilter").addEventListener('click', () => {
                let date_debut = document.getElementById('date_debut').value;
                let date_fin = document.getElementById('date_fin').value;
                let clientSearch = document.getElementById('clientSearch').value;
                let url = "<?php echo e(route('invoices.index')); ?>";
                if (date_debut != null && date_debut != "") {
                    url += "?date_debut=" + date_debut;
                    if (date_fin != null && date_fin != "") {
                        url += "&date_fin=" + date_fin;
                        if (clientSearch != null && clientSearch != "") {
                            url += "&client=" + clientSearch;
                        }
                    } else {
                        if (clientSearch != null && clientSearch != "") {
                            url += "&client=" + clientSearch;
                        }
                    }
                } else {
                    if (clientSearch != null && clientSearch != "") {
                        url += "?client=" + clientSearch;
                    }
                }
                window.location.href = url;

            })
            // get query params 
            const urlParams = new URLSearchParams(window.location.search);
            const date_debut = urlParams.get('date_debut');
            const date_fin = urlParams.get('date_fin');
            const clientSearch = urlParams.get('client');
            document.getElementById('date_debut').value = date_debut;
            document.getElementById('date_fin').value = date_fin;
            if (clientSearch != null && clientSearch != "") {
                document.getElementById('clientSearch').value = clientSearch;
            }
        <?php endif; ?>
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mrtechtndd/www/fact/resources/views/pages/statements/index.blade.php ENDPATH**/ ?>