<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Détails des TVA par Facture</h3>
            <div class="col-sm-6">
            </div>
        </div>
        <div class="card-body">
            <div class="row mb-3">
                <div class="col-md-3">
                    <label>Client:</label>
                    <select class="form-control" name="client" id="client">
                        <option value="">Tous</option>
                        <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($client->id); ?>" <?php echo e(request('client') == $client->id ? 'selected' : ''); ?>><?php echo e($client->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label>Date de début:</label>
                    <input type="date" class="form-control" name="date_debut" id="date_debut" value="<?php echo e(request('date_debut')); ?>">
                </div>
                <div class="col-md-3">
                    <label>Date de fin:</label>
                    <input type="date" class="form-control" name="date_fin" id="date_fin" value="<?php echo e(request('date_fin')); ?>">
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <button class="btn btn-primary mr-2" onclick="applyFilter()">Filtrer</button>
                    <button class="btn btn-secondary" onclick="resetFilter()">Réinitialiser</button>
                </div>
            </div>
            <div class="table-responsive">
                <table id="table-tva-details" class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Numéro</th>
                            <th>Code</th>
                            <th>Client</th>
                            <th>Hors TVA</th>
                            <th>TVA 19%</th>
                            <th>Hors TVA 7%</th>
                            <th>TVA 7%</th>
                            <th>Timbre</th>
                            <th>TTC</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $statements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($statement->date); ?></td>
                                <td><?php echo e($statement->reference); ?></td>
                                <td><?php echo e($statement->client->id ?? ''); ?></td>
                                <td><?php echo e($statement->client->name ?? ''); ?></td>
                                <td><?php echo e(number_format($statement->getBaseHtForTva(19), 3)); ?></td>
                                <td><?php echo e(number_format($statement->getTvaAmount(19), 3)); ?></td>
                                <td><?php echo e(number_format($statement->getBaseHtForTva(7), 3)); ?></td>
                                <td><?php echo e(number_format($statement->getTvaAmount(7), 3)); ?></td>
                                <td><?php echo e(number_format($statement->timbreFiscal, 3)); ?></td>
                                <td><?php echo e(number_format($statement->ttc, 3)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>

<script>
    $(document).ready(function() {
        var table = $('#table-tva-details').DataTable({
            dom: 'Bfrtip',
            buttons: [{
                extend: 'excel',
                className: 'btn btn-success',
                text: 'Exporter Excel',
                title: 'detailstva_' + new Date().toISOString().split('T')[0],
                customize: function(xlsx) {
                    var sheet = xlsx.xl.worksheets['sheet1.xml'];
                    // Style pour la colonne numéro (B)
                    $('row c[r^="B"]', sheet).attr('s', '2');
                    // Ajouter un style personnalisé pour le rouge et gras
                    var styles = xlsx.xl['styles.xml'];
                    var lastStyle = $('cellXfs xf', styles).length;
                    var boldRedStyle = '<xf numFmtId="0" fontId="0" fillId="0" borderId="0" xfId="0" applyFont="1" applyFill="1">' +
                        '<font><b/><color rgb="FFFF0000"/></font>' +
                        '</xf>';
                    $('cellXfs', styles).append(boldRedStyle);
                    $('row c[r^="B"]', sheet).attr('s', lastStyle);
                }
            }],
            pageLength: 25,
            order: [[0, 'desc']],
            language: {
                url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/fr-FR.json'
            },
            columnDefs: [{
                targets: [4,5,6,7,8,9], // Colonnes des montants (index commence à 0)
                render: function(data, type, row) {
                    if (type === 'display') {
                        // S'assurer que data est un nombre
                        let num = typeof data === 'string' ? parseFloat(data.replace(/[^\d.-]/g, '')) : parseFloat(data);
                        if (!isNaN(num)) {
                            return num.toFixed(3) ;
                        }
                        return '0.000';
                    }
                    return data;
                }
            },
            {
                targets: [1], // Colonne numéro (index 1)
                className: 'fw-bold text-danger'
            }]
        });
    });

    function applyFilter() {
        const client = document.getElementById('client').value;
        const dateDebut = document.getElementById('date_debut').value;
        const dateFin = document.getElementById('date_fin').value;

        let url = '<?php echo e(route("statements.tva-details")); ?>?';
        if (client) url += `client=${client}&`;
        if (dateDebut) url += `date_debut=${dateDebut}&`;
        if (dateFin) url += `date_fin=${dateFin}`;

        window.location.href = url;
    }

    function resetFilter() {
        window.location.href = '<?php echo e(route("statements.tva-details")); ?>';
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rjlbpor/www/resources/views/pages/statements/tva_details.blade.php ENDPATH**/ ?>