<html>

<head>
    <meta charset="utf-8">
    <title><?php echo e($name); ?></title>
    <style>
        /* reset */

        * {
            border: 0;
            box-sizing: content-box;
            color: inherit;
            font-family: inherit;
            font-size: inherit;
            font-style: inherit;
            font-weight: inherit;
            line-height: inherit;
            list-style: none;
            margin: 0;
            padding: 0;
            text-decoration: none;
            vertical-align: top;
        }

        /* heading */

        h1 {
            font: bold 100% sans-serif;


            text-transform: uppercase;
        }

        h2 {
            font: bold 100% sans-serif;
            letter-spacing: 0.5em;
            text-align: center;
            text-transform: uppercase;
        }

        /* table */

        table {
            font-size: 75%;
            table-layout: fixed;
            width: 100%;
        }

        table {
            border-collapse: separate;
            border-spacing: 2px;
        }

        th,
        td {
            border-width: 1px;
            padding: 0.5em;
            position: relative;
            text-align: left;
        }

        th,
        td {
            border-radius: 0.25em;
            border-style: solid;
        }

        th {
            background: #EEE;
            border-color: #BBB;
        }

        td {
            border-color: #DDD;
        }

        /* page */

        html {
            font: 16px/1 'Open Sans', sans-serif;

            padding: 0.5in;

        }

        html {
            background: #999;
            cursor: default;
        }

        body {
            box-sizing: border-box;
            height: 11in;
            margin: 0 auto;

            padding: 0.5in;
            width: 7in;
        }

        body {
            background: #FFF;
            border-radius: 1px;
            box-shadow: 0 0 1in -0.25in rgba(0, 0, 0, 0.5);
        }

        /* header */

        header {
            margin: 0 0 3em;
        }

        header:after {
            clear: both;
            content: "";
            display: table;
        }

        header h1 {
            background: #000;
            border-radius: 10px;
            color: #FFF;
            margin: 0 0 1em;
            padding: 0.5em 0;
            text-align: center;
            letter-spacing: 1rem;
        }

        header address {
            float: left;
            font-size: 75%;
            font-style: normal;
            line-height: 1.25;
            margin: 0 1em 1em 0;
        }

        header address p {
            margin: 0 0 0.25em;
        }

        header span,
        header img {
            display: block;
            float: right;
        }

        header span {
            margin: 0 0 1em 1em;
            max-height: 25%;
            max-width: 60%;
            position: relative;
        }

        header img {
            max-height: 100%;
            max-width: 100%;
        }

        header input {
            cursor: pointer;
            -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";
            height: 100%;
            left: 0;
            opacity: 0;
            position: absolute;
            top: 0;
            width: 100%;
        }

        /* article */

        article,
        article address,
        table.meta,
        table.inventory {
            margin: 0 0 3em;
        }

        article:after {
            clear: both;
            content: "";
            display: table;
        }

        article h1 {
            clip: rect(0 0 0 0);
            position: absolute;
        }

        article address {
            float: left;

            font-size: 75%;
            font-style: normal;
            line-height: 1.25;
            margin: 0 1em 1em 0;

        }

        .Client {
            float: right;
            text-align: right;
            font-size: 75%;
            font-style: normal;
            line-height: 1.25;
            margin: 0 1em 1em 0;

        }

        /* table meta & balance */

        table.meta,
        table.balance {
            float: right;
            width: 36%;
        }

        table.meta:after,
        table.balance:after {
            clear: both;
            content: "";
            display: table;
        }

        /* table meta */

        table.meta th {
            width: 40%;
        }

        table.meta td {
            width: 60%;
        }

        /* table items */

        table.inventory {
            clear: both;
            width: 100%;
        }

        table.inventory th {
            font-weight: bold;
            text-align: center;
        }


        /* table balance */

        table.balance th,
        table.balance td {
            width: 50%;
        }

        table.balance td {
            text-align: right;
        }

        /* aside */

        footer {
            position: fixed;
            bottom: 0%;
            float: left;
            font-size: 75%;
            font-style: normal;
            line-height: 1.25;
            margin: 0 1em 1em 0;
        }


        /* javascript */

        .add,
        .cut {
            border-width: 1px;
            display: block;
            font-size: .8rem;
            padding: 0.25em 0.5em;
            float: left;
            text-align: center;
            width: 0.6em;
        }



        @media print {
            * {
                -webkit-print-color-adjust: exact;
            }

            html {
                background: none;
                padding: 0;
            }

            body {
                box-shadow: none;
                margin: 0;
            }

            span:empty {
                display: none;
            }

            .add,
            .cut {
                display: none;
            }
        }

        @page {
            margin: 0;
        }
    </style>
</head>

<body>
    <header>
        <h1>
            <?php if($statement->type == 1): ?>
            Facture
            <?php elseif($statement->type == 2): ?>
            Devis
            <?php else: ?>
            Commande
            <?php endif; ?></h1>
        <address>
            <p><?php echo e($company->address); ?></p>
            <p><?php echo e($company->matFisc); ?></p>
            <p><?php echo e($company->address); ?></p>
            <p><?php echo e($company->phone); ?></p>
            <p><?php echo e($company->email); ?></p>
        </address>
        <address class="Client">

            <p><?php echo e($client->address); ?></p>
            <p><?php echo e($client->matFisc); ?></p>
            <p><?php echo e($client->address); ?></p>
            <p><?php echo e($client->tel); ?></p>
            <p><?php echo e($client->email); ?></p>
        </address>

    </header>

    <br>
    <article>

        <table class="meta">
            <tr>
                <th><span> <?php if($statement->type == 1): ?>
                        Facture
                        <?php elseif($statement->type == 2): ?>
                        Devis
                        <?php else: ?>
                        Commande
                        <?php endif; ?> #</span></th>
                <td><span><?php echo e($statement->getId()); ?> </span></td>
            </tr>
            <tr>
                <th><span>Date</span></th>
                <td><span><?php echo e($date); ?></span></td>
            </tr>

        </table>
        <table class="inventory">
            <thead>

                <tr>
                    <th><span>Article</span></th>

                    <th><span>Prix Unitaire</span></th>
                    <th><span>Quantité</span></th>
                    <th><span>Prix</span></th>
                    <th><span>Remise</span></th>
                    <th><span>Prix après remise</span></th>
                    <th><span>TVA</span></th>
                </tr>

            </thead>
            <tbody>
                <?php $total = 0; $i=0;
                ?>

                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <tr>
                    <td><span><?php echo e($list->product); ?></span></td>

                    <td><span><?php echo e($list->price); ?></span><span data-prefix></span></td>
                    <td><span><?php echo e($list->quantity); ?></span></td>
                    <td><span><?php echo e($list->price*$list->quantity); ?></span><span data-prefix></span></td>
                    <td><span><?php echo e($list->discount); ?></span><span data-prefix>%</span></td>
                    <td><span><?php echo e($list->price * $list->quantity * (100-$list->discount)/100); ?></span><span data-prefix></span></td>
                    <td><span><?php echo e($list->tva); ?></span><span data-prefix>%</span></td>
                </tr>
                <?php $i++
                ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php $i=0
                ?>
            </tbody>
        </table>

        <table class="balance">
            <thead>

                <tr>
                    <th><span>TVA</span></th>
                    <th><span>Base</span></th>
                    <th><span>Montant</span></th>
                </tr>

            </thead>
            <tbody>
                <?php $__currentLoopData = $tvaCollection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <tr>
                    <td><span><?php echo e($key); ?></span></td>

                    <td><span><?php echo e($value[0]); ?></span></td>
                    <td><span><?php echo e($value[1]); ?></span></td>
                </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            </tbody>
        </table>
    </article>
    <table class="balance">
        <tr>
            <th><span>Quantité</span></th>
            <td><span><?php echo e($statement->gqte); ?></span></td>
        </tr>
        <tr>
            <th><span>Total Hors Taxes</span></th>
            <td><span><?php echo e($statement->tht); ?></span></td>
        </tr>
        <tr>
            <th><span>Remise</span></th>
            <td><span><?php echo e($totalDiscount); ?></span></td>
        </tr>
        <tr>
            <th><span>TVA</span></th>
            <td><span><?php echo e($statement->tva); ?></span></td>
        </tr>
        <?php if($statement->type == 1): ?>
        <tr>
            <th><span>Timbre Fiscal</span></th>
            <td><span><?php echo e($statement->timbreFiscal); ?></span></td>
        </tr>
        <?php endif; ?>
        <tr>
            <th><span>Total TTC</span></th>

            <td><span><?php echo e($statement->ttc); ?></span></td>

        </tr>

    </table>

    <footer>
        <hr>

        <p>RIB :<?php echo e($company->rib); ?> <?php echo e($company->bank); ?>, <?php echo e($company->agency); ?></p>


    </footer>
</body>

</html><?php /**PATH /home/ahmed/facture/ap/resources/views/pdf/statement.blade.php ENDPATH**/ ?>