<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statements', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('client_id')->default('0');
            $table->unsignedBigInteger('user_id')->default('0');
            $table->decimal('timbreFiscal',15,3)->nullable();
            $table->string('reference')->nullable();
            $table->decimal('tht',15,3)->nullable();
            $table->decimal('ttc',15,3)->nullable();
            $table->decimal('tva',15,3)->nullable();
            $table->decimal('gqte',15,3)->nullable();
            $table->integer('type');
            $table->string('comment')->nullable();
            $table->timestamps();
            $table->foreign('client_id')->references('id')->on('clients')->onUpdate('no action')->onDelete('no action');
            $table->foreign('user_id')->references('id')->on('users')->onUpdate('no action')->onDelete('no action');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statements');
    }
};
