<?php

namespace App\Http\Controllers;

use App\Models\BonDEntrees;
use App\Models\Clients;
use App\Models\Products;
use App\Models\Settings;
use Illuminate\Http\Request;

class BonDEntreesController extends Controller
{
    public function index()
    {
        $bons = BonDEntrees::with('products','fournisseurs')->orderBy('created_at', 'desc')->get();
        return view('pages.bon_d_entree.index', ['bons' => $bons]);
    }

    public function store(Request $request)
    {

        $form_fields = $request->validate([
            'reference' => 'required|string',
            'fournisseur' => 'nullable',
            'facture' => 'nullable|string',
            'comment' => ['nullable', 'string'],
            'date' => ['nullable', 'date']
        ]);
        $form_fields['user_id'] = auth()->user()->id;

        $bonDEntrees = BonDEntrees::create($form_fields);

        $productsData = $request->input('produits');
        $productsData = json_decode($productsData, true);
        foreach ($productsData as $productData) {

            $productId = $productData['id'];
            $quantity = $productData['quantité'];
            $price = $productData['price'];
            $bonDEntrees->products()->attach($productId, ['quantity' => $quantity, 'price' => $price]);
        }

        return redirect()->route('bon_d_entrees.index');
    }

    public function show($id = null)
    {
        $products = Products::all();
        $bon = null;
        $newestBon = BonDEntrees::orderBy('created_at', 'desc')->first();
        $ref = null;
        if (!$newestBon) {
            $ref = 'BL' . date('Y') . '0001';
        } else {
            $ref = $newestBon->getId();
        }
        if ($id) {
            $bon = BonDEntrees::with('products')->findOrFail($id);
        }
        $date = now()->toDateString();
        $fournisseurs = Clients::where('type', 1)->get();
        return view('pages.bon_d_entree.show', ['bon' => $bon, 'products' => $products, 'ref' => $ref, 'date' => $date, 'fournisseurs' => $fournisseurs]);
    }

    public function update(Request $request, $id)
    {
        $form_fields = $request->validate([
            'reference' => 'required|string',
            'fournisseur' => 'nullable',
            'facture' => 'nullable|string',
            'comment' => ['nullable', 'string'],
            'date' => ['nullable', 'date']
        ]);
        $form_fields['edit_id'] = auth()->user()->id;
        $bonDEntrees = BonDEntrees::findOrFail($id);

        $bonDEntrees->update($form_fields);

        $productsData = $request->input('produits');
        $productsData = json_decode($productsData, true);
        $updatedProducts = [];
        foreach ($productsData as $productData) {
            $productId = $productData['id'];
            $quantity = $productData['quantité'];
            $price = $productData['price'];
            $updatedProducts[$productId] = ['quantity' => $quantity, 'price' => $price];
        }

        $bonDEntrees->products()->sync($updatedProducts);

        return redirect()->route('bon_d_entrees.index');
    }

    public function destroy($id)
    {
        $bon_d_entree = BonDEntrees::findOrFail($id);
        $bon_d_entree->delete();
        return redirect()->back();
    }

    public function getPDF(BonDEntrees $bon)
    {
        $date = date('d/m/Y', strtotime($bon->updated_at));
        $settings = Settings::find(1)->get();
        $filename = 'BL-' . $bon->reference . '.pdf';
        $client = Clients::where('id', $bon->fournisseur)->first();
        $settings = Settings::all()->first();
        $items = $bon->products()->withPivot('quantity','price')->get();
        $data = [
            "name" => $filename,
            "bon" => $bon,
            "items" => $items,
            "company" => $settings,
            "date" => $date,
            "client" => $client,
        ];
        $pdf = \PDF::loadView('pdf.entree', $data);
        return $pdf->stream($filename);
    }
}
