<?php

namespace App\Http\Controllers;

use App\Models\Settings;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index()
    {
        $bon = Settings::all()->first();
        return view('pages.settings.index', ['bon' => $bon]);
    }

    public function update($id, Request $request)
    {
        
        $setting = Settings::findOrFail($id);
        $form_fields = request()->validate([
            'password' => 'required',
            'tmbr' => 'required',
            'company' => 'required',
            'address' => 'required',
            'phone' => 'required',
            'email' => ['nullable', 'email'],
            'matFisc' => 'required',
            'rib' => 'required',
            'bank' => 'required',
            'agency' => 'required',
            'factimg' => 'nullable',
            'qtezero' => 'nullable',
        ]);
        if (request()->hasFile('logo')) {
            $file = request()->file('logo');
            $fileName =  $file->getClientOriginalName();
            if ($file->move(public_path() . '/static/', $fileName)) {
                $form_fields['logo'] = $fileName;
            }
        } else {
            $form_fields['logo'] = null;
        }
        if (request()->has('factimg')) {
            $form_fields['factimg'] = 1;
        } else {
            $form_fields['factimg'] = 0;
        }
        if (request()->has('qtezero')) {
            $form_fields['qtezero'] = 1;
        } else {
            $form_fields['qtezero'] = 0;
        }
        $setting->update($form_fields);
        return redirect()->back();
    }

}
