<?php

namespace App\Http\Controllers;

use App\Models\Clients;
use App\Models\Products;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index()
    {
        $month = date('m');
        $year = date('Y');
        $products = Products::with('items')->get();
        $products = $products->sortByDesc(function ($product) {
            return $product->items->sum(function ($item) {
                return $item->statement->type == 1 ? $item->quantity : 0;
            });
        });
        $maxItemsToTake = min(8, $products->count());
        $products = $products->take($maxItemsToTake);

        return view('pages.dashboard.index', ['products' => $products, 'month' => $month, 'year' => $year]);
    }

    public function clients(Request $request)
    {
        $month = $request->input('month');
        $year = $request->input('year');
        if ($month == null) {
            $month = date('m');
        }
        if ($year == null) {
            $year = date('Y');
        }
        $date = date('Y-m-01', strtotime($year . '-' . $month));
        $nextMonthDate = date('Y-m-d', strtotime($date . ' +1 month'));
        $clients = Clients::with(['statements' => function ($query) use ($date, $nextMonthDate) {
            $query->whereDate('date', '>=', $date);
            $query->whereDate('date', '<', $nextMonthDate);
            $query->orderBy('ttc', 'desc');
            $query->where('type', 1);
        }, 'statements.reglements'])->get();
        return response()->json($clients);
        // return response()->json($clients);
    }
}
