<?php

namespace App\Http\Controllers;

use App\Models\Dossier;
use Illuminate\Http\Request;

class DossierController extends Controller
{
    /**
     * Display a listing of all dossiers with a view.
     */
    public function index()
    {
        $dossiers = Dossier::with('fichiers')->get(); // Eager load fichiers relationship
        return view('pages.dossiers.index', compact('dossiers')); // Pass data to the view
    }

    /**
     * Store a newly created dossier in the database and redirect back.
     */
    public function store(Request $request)
    {
        // Validate the request data
        $validated = $request->validate([
            'name' => 'required|string|max:255',
        ]);

        // Create a new dossier
        Dossier::create($validated);

        return back()->with('success', 'Dossier créé avec succès'); // Redirect back with success message
    }

    /**
     * Update the specified dossier in the database and redirect back.
     */
    public function update(Request $request, $id)
    {
        // Validate the request data
        $validated = $request->validate([
            'name' => 'required|string|max:255',
        ]);

        // Find the dossier by ID
        $dossier = Dossier::findOrFail($id);

        // Update the dossier
        $dossier->update($validated);

        return back()->with('success', 'Dossier modifié avec succès'); // Redirect back with success message
    }

    /**
     * Remove the specified dossier from the database and redirect back.
     */
    public function delete($id)
    {
        // Find the dossier by ID
        $dossier = Dossier::findOrFail($id);

        // Delete the dossier (this will cascade delete related fichiers if configured in the database)
        $dossier->delete();

        return back()->with('success', 'Dossier supprimé avec succès'); // Redirect back with success message
    }
}