<?php

namespace App\Http\Controllers;

use App\Models\Clients;
use Illuminate\Http\Request;

class ClientsController extends Controller
{
    public function index()
    {
        $clients = Clients::where('type', 0)->get();
        return view('pages.clients.index', ['clients' => $clients]);
    }

    public function fournisseur()
    {
        $clients = Clients::where('type', 1)->get();
        return view('pages.clients.fournisseur', ['clients' => $clients]);
    }

    public function store(Clients $client)
    {
        $form_fields = request()->validate([
            'name' => 'required',
            'matFisc' => 'nullable',
            'address' => 'nullable',
            'tel' => 'nullable',
            'email' => ['nullable', 'email'],
            'is_exempt_tva' => 'nullable',
            'type' => 'required',
        ]);
        if (request()->hasFile('image')) {
            $file = request()->file('image');
            $fileName =  $file->getClientOriginalName();
            if ($file->move(public_path() . '/storage/clients/', $fileName)) {
                $form_fields['image'] = $fileName;
            }
        }
        $client = Clients::create($form_fields);
        return redirect()->back();
    }

    public function show($id)
    {
        $client = Clients::findOrFail($id);
        return response()->json($client);
    }

    public function update($id, Request $request)
    {
        $client = Clients::findOrFail($id);
        $form_fields = request()->validate([
            'name' => 'required',
            'matFisc' => 'nullable',
            'address' => 'nullable',
            'tel' => 'nullable',
            'email' => ['nullable'],
            'is_exempt_tva' => 'nullable',
            'type' => 'required',
        ]);
        if (request()->hasFile('image')) {
            $file = request()->file('image');
            $fileName =  $file->getClientOriginalName();
            if ($file->move(public_path() . '/storage/clients/', $fileName)) {
                $form_fields['image'] = $fileName;
            }
        }else{
            $form_fields['image'] = null;
        }
        $client->update($form_fields);
        return redirect()->back();
    }

    public function destroy($id)
    {
        $client = Clients::findOrFail($id);
        $client->delete();
        return redirect()->back();
    }
}
