<?php $__env->startSection('title', 'Bons d\'entrées'); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('dist/css/hotspot/hotspot.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dist/css/hotspot/style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">
                                    <?php if($statement): ?>
                                        Modifier
                                    <?php else: ?>
                                        Ajouter
                                    <?php endif; ?>
                                    <?php if($type == 1): ?>
                                        Facture
                                    <?php endif; ?>
                                    <?php if($type == 2): ?>
                                        Devis
                                    <?php endif; ?>
                                </h5>

                            </div>
                            <form method="POST" id="form" enctype="multipart/form-data"
                                action="<?php echo e(route('statements.store')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-body">
                                    <div class="row">

                                        <div class="form-group col-6">
                                            <label>Client: </label>
                                            <select name="client_id" class="form-control" id="selectClients">
                                                <option value="0" disabled>--</option>
                                                <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if($statement && $statement->client_id == $client->id): ?> selected <?php endif; ?>
                                                        value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <input type="hidden" name="type" value="<?php echo e($type); ?>">

                                        <?php if($type == 1): ?>
                                            <div class="form-group col-6">
                                                <label>Timbre Fiscal: </label>
                                                <input type="number" step="0.001" name="timbreFiscal"
                                                    value="<?php echo e($statement ? $statement->timbreFiscal : $timbre); ?>"
                                                    class="form-control">
                                            </div>
                                        <?php endif; ?>
                                        <input type="hidden" id="productsInput" name="items">
                                        <div class="form-group col-12">
                                            <div class="row">
                                                <div class="col-3">
                                                    <label>Produits</label>
                                                </div>
                                                <div class="col-1">
                                                    <label>Quantité</label>
                                                </div>
                                                <div class="col-1">
                                                    <label>Prix</label>
                                                </div>
                                                <div class="col-1">
                                                    <label>Remise</label>
                                                </div>
                                                <div class="col-1">
                                                    <label>TVA</label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-3">
                                                    <select id="selectProducts" class="selectProducts form-control">
                                                        <option value="0" selected disabled>--</option>
                                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="form-group col-1">
                                                    <input type="number" step="1" min="0"
                                                        id="quantitéProducts" class="form-control" value="0">
                                                </div>
                                                <div class="form-group col-1">
                                                    <input type="number" step="0.001" min="0" id="priceProducts"
                                                        class="form-control">
                                                </div>
                                                <div class="form-group col-1">
                                                    <input type="number" step="0.001" min="0"
                                                        id="discountProducts" class="form-control">
                                                </div>
                                                <div class="form-group col-1">
                                                    <input type="number" step="0.001" min="0" id="tvaProducts"
                                                        class="form-control">
                                                </div>
                                                <div class="d-flex col-2">
                                                    <div>
                                                        <button type="button" class="btn btn-primary mx-1"
                                                            id="addProduct">Ajouter</button>
                                                    </div>
                                                    <div id="annuler">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div>
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">Produit</th>
                                                        <th scope="col">Quantité</th>
                                                        <th scope="col">Prix Unit.</th>
                                                        <th scope="col">Montant HT</th>
                                                        <th scope="col">Remise %</th>
                                                        <th scope="col">Montant Remise</th>
                                                        <th scope="col">Montant HT Net</th>
                                                        <th scope="col">TVA %</th>
                                                        <th scope="col">Montant TVA</th>
                                                        <th scope="col">Total</th>
                                                        <th scope="col">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="tbody">

                                                </tbody>
                                            </table>
                                        </div>



                                        <div class="modal-footer">

                                            <button type="submit" class="btn btn-primary ml-1">
                                                <i class="bx bx-check d-block d-sm-none"></i>
                                                <span class="d-none d-sm-block text-white">
                                                    <?php if($statement): ?>
                                                        Modifier
                                                    <?php else: ?>
                                                        Ajouter
                                                    <?php endif; ?>
                                                </span>
                                            </button>
                                        </div>

                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('dist/js/simple-datatables/simple-datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('dist/js/vendors.js')); ?>"></script>
    <script>
        <?php if($statement): ?>
            const products = <?php echo json_encode(
                $statement->items->map(function ($item) {
                        return [
                            'id' => $item->product_id,
                            'quantité' => $item->quantity,
                            'price' => $item->price,
                            'discount' => $item->discount,
                            'tva' => $item->tva,
                        ];
                    })->values(),
            ); ?>;
        <?php else: ?>
            const products = [];
        <?php endif; ?>
        let index = 0;
        let update = false;
        const originalProducts = <?php echo json_encode(
            $products->map(function ($product) {
                $quantity = 0;
                foreach ($product->bon_d_entrees as $bon) {
                    $quantity += $bon->pivot->quantity;
                }
                return [
                    'id' => $product->id,
                    'name' => $product->name,
                    'price' => $product->price,
                    'tva' => $product->tva,
                    'quantity' => $quantity,
                ];
            }),
        ); ?>;
        const clients = <?php echo json_encode($clients, 15, 512) ?>;
        let client = null;
        const button = document.getElementById('addProduct');
        button.addEventListener('click', () => {
            if (update) {
                const select = document.getElementById('selectProducts');
                const quantité = document.getElementById('quantitéProducts');
                const price = document.getElementById('priceProducts');
                const discount = document.getElementById('discountProducts');
                const tva = document.getElementById('tvaProducts');
                products[index] = {
                    id: select.value,
                    quantité: quantité.value,
                    price: price.value,
                    discount: discount.value,
                    tva: tva.value
                };
                select.value = 0;
                quantité.value = 0;
                price.value = 0;
                discount.value = 0;
                tva.value = 0;
                button.innerHTML = 'Ajouter';
                update = false;
                index = 0;
                const annuler = document.getElementById('annuler');
                annuler.innerHTML = '';
                updateTable();
            } else {
                const select = document.getElementById('selectProducts');
                const quantité = document.getElementById('quantitéProducts');
                const price = document.getElementById('priceProducts');
                const discount = document.getElementById('discountProducts');
                const tva = document.getElementById('tvaProducts');
                products.push({
                    id: select.value,
                    quantité: quantité.value,
                    price: price.value,
                    discount: discount.value,
                    tva: tva.value
                });
                select.value = 0;
                quantité.value = 0;
                price.value = 0;
                discount.value = 0;
                tva.value = 0;
                updateTable();
            }
        })

        function updateTable() {
            const tbody = document.getElementById('tbody');
            tbody.innerHTML = '';
            products.forEach((product) => {
                const p = originalProducts.find((p) => p.id == product.id);
                tbody.innerHTML += `
                    <tr id="p-${product.id}">
                        <td>${p.name}</td>
                        <td>${product.quantité}</td>
                        <td>${product.price}</td>
                        <td>${product.quantité * product.price}</td>
                        <td>${product.discount}</td>
                        <td>${product.quantité * product.price * product.discount / 100}</td>
                        <td>${product.quantité * product.price - product.quantité * product.price * product.discount / 100}</td>
                        <td>${product.tva}</td>
                        <td>${product.quantité * product.price * product.tva / 100}</td>
                        <td>${(product.quantité * product.price - product.quantité * product.price * product.discount / 100)+(product.quantité * product.price * product.tva / 100)}</td>
                        <td>
                            <button type="button" class="btn btn-warning" onclick="updateProduct('${product.id}','${product.quantité}','${product.price}')">Modifier</button>
                            <button type="button" class="btn btn-danger" onclick="removeProduct('p-${product.id}','${product.quantité}','${product.price}')">Supprimer</button>
                        </td>
                    </tr>
                `;
            })
        }
        updateTable();

        function removeProduct(id, quantité, prix) {
            const p_id = id.split('-')[1];
            const prod = products.find((p) => p.id == p_id && p.quantité == quantité && p.price == prix);
            const index = products.indexOf(prod);
            products.splice(index, 1);
            updateTable();
        }

        function updateProduct(id, quantity, prix) {
            const select = document.getElementById('selectProducts');
            const quantité = document.getElementById('quantitéProducts');
            const price = document.getElementById('priceProducts');
            const discount = document.getElementById('discountProducts');
            const tva = document.getElementById('tvaProducts');
            const product = products.find((p) => p.id == id && p.quantité == quantity && p.price == prix);
            select.value = product.id;
            quantité.value = product.quantité;
            price.value = product.price;
            discount.value = product.discount;
            if (getClient()) {
                tva.value = 0;
            } else {
                tva.value = product.tva;
            }
            const annuler = document.getElementById('annuler');
            annuler.innerHTML = `<button type="button" class="btn btn-danger mx-1" id="annulerProduct">Annuler</button>`;
            const annulerProduct = document.getElementById('annulerProduct');
            annulerProduct.addEventListener('click', () => {
                select.value = 0;
                quantité.value = 0;
                price.value = 0;
                discount.value = 0;
                if (getClient()) {
                    tva.value = 0;
                } else {
                    tva.value = product.tva;
                }
                annuler.innerHTML = '';
                button.innerHTML = 'Ajouter';
                update = false;
                index = 0;
            })
            button.innerHTML = 'Modifier';
            update = true;
            index = products.indexOf(product);
        }


        const form = document.getElementById('form');
        form.addEventListener('submit', (e) => {
            e.preventDefault();
            const productsInput = document.getElementById('productsInput');
            productsInput.value = JSON.stringify(products);
            form.submit();
        })

        const select = document.getElementById('selectProducts');
        select.addEventListener('change', () => {
            const product = originalProducts.find((p) => p.id == select.value);
            const price = document.getElementById('priceProducts');
            const discount = document.getElementById('discountProducts');
            const quantité = document.getElementById('quantitéProducts');
            const tva = document.getElementById('tvaProducts');
            quantité.setAttribute('max', product.quantity);
            price.value = product.price;
            discount.value = 0;
            if (getClient()) {
                tva.value = 0;
            } else {
                tva.value = product.tva;
            }
        })

        function getClient(){
            const selectClients = document.getElementById('selectClients');
            const client_id = selectClients.value;
            client = clients.find((c) => c.id == client_id);
            return client!=null && client !='undefined' ? client.is_exempt_tva : false;
        }
        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ahmed/facture/ap/resources/views/pages/statements/show.blade.php ENDPATH**/ ?>