@extends('welcome')
@section('title', 'Fichiers')
@section('styles')
    <link href="{{ asset('dist/css/hotspot/hotspot.css') }}" rel="stylesheet" />
    <link href="{{ asset('dist/css/hotspot/style.css') }}" rel="stylesheet" />
@endsection

@section('content')
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">{{ $dossier->name }}: Fichiers</h5>
                                @if (Auth::user()->role_id == 1)
                                    <button type="button" data-bs-toggle="modal" data-bs-target="#inlineForm"
                                        class="btn btn-primary">Ajouter</button>
                                @endif
                            </div>
                          <div class="table-responsive">
    <div class="row"> <!-- Ajout de la row ici -->
        @forelse ($fichiers as $fichier)
            <div class="col-md-3 mb-4">
                <div class="card">
                    <!-- File Preview -->
                    <div class="card-img-top"
                        style="height: 50px; display: flex; align-items: center; justify-content: center;">
                        @if (in_array(pathinfo($fichier->path, PATHINFO_EXTENSION), ['jpg', 'jpeg', 'png', 'gif']))
                            <!-- If the file is an image -->
                            <img src="{{ asset('storage/fichiers/' . $fichier->path) }}"
                                alt="{{ $fichier->name }}"
                                style="max-height: 100%; max-width: 100%;">
                        @else
                            <!-- If the file is not an image, use a placeholder -->
                            <img src="{{asset('static/2.png')}}" alt="Placeholder Image"
                                style="max-height: 100%; max-width: 100%;">
                        @endif
                    </div>

                    <!-- Card Body -->
                    <div class="card-body">
                        <!-- Buttons -->
                        <div class="d-flex justify-content-between flex-wrap">
						<center>{{$fichier->path}}
                            <a href="{{ asset('storage/fichiers/' . $fichier->path) }}" download
                                target="_blank" class="btn btn-primary m-1">Télécharger</a>
                            @if (Auth::user()->role_id == 1)
                                <button onclick="openModal('{{ $fichier->path }}', '{{ $fichier->id }}')"
                                    class="btn btn-warning m-1">Modifier</button>
                                <button onclick="deleteItem('{{ $fichier->id }}')"
                                    class="btn btn-danger m-1">Supprimer</button>
                            @endif
                       </center> </div>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12 text-center">
                <div class="alert alert-info" role="alert">
                    Pas de fichier pour ce dossier
                </div>
            </div>
        @endforelse
    </div> <!-- Fin de la row -->
</div>

                                <form id="delete" method="POST">
                                    @method('DELETE')
                                    @csrf

                                </form>
                                <!--End Row-->

                                <div class="modal fade text-left " id="inlineForm" tabindex="-1" role="dialog"
                                    aria-labelledby="myModalLabel33" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-scrollable" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="myModalLabel33">Ajouter </h4>
                                                <button type="button" class="close" data-bs-dismiss="modal"
                                                    aria-label="Close">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
                                                        <path
                                                            d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                                    </svg>
                                                </button>
                                            </div>
                                            <form method="POST" action="{{ route('fichiers.store') }}"
                                                enctype="multipart/form-data" id="formmm">
                                                @csrf
                                                <div class="modal-body">
                                                    <input type="hidden" name="id_dossier"
                                                        value="{{ request()->route('id') }}">

                                                    <input type="file" name="path" class="multiple-files-filepond">


                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light-secondary"
                                                        data-bs-dismiss="modal">
                                                        <i class="bx bx-x d-block d-sm-none"></i>
                                                        <span class="d-none d-sm-block">Annuler</span>
                                                    </button>
                                                    <button type="submit" class="btn btn-primary ml-1">
                                                        <i class="bx bx-check d-block d-sm-none"></i>
                                                        <span class="d-none d-sm-block text-white">Ajouter</span>
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade text-left " id="edit" tabindex="-1" role="dialog"
                                    aria-labelledby="myModalLabel33" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-scrollable" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="myModalLabel33">Modifier </h4>
                                                <button type="button" class="close" data-bs-dismiss="modal"
                                                    aria-label="Close">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
                                                        <path
                                                            d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                                    </svg>
                                                </button>
                                            </div>
                                            <form method="POST" id="formEdit" enctype="multipart/form-data">
                                                @method('PUT')
                                                @csrf
                                                <div class="modal-body">
                                                    <input type="hidden" name="id_dossier"
                                                        value="{{ request()->route('id') }}">

                                                    <input type="file" name="path"
                                                        class="multiple-files-filepond-edit">

                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light-secondary"
                                                        data-bs-dismiss="modal">
                                                        <i class="bx bx-x d-block d-sm-none"></i>
                                                        <span class="d-none d-sm-block">Annuler</span>
                                                    </button>
                                                    <button type="submit" class="btn btn-primary ml-1">
                                                        <i class="bx bx-check d-block d-sm-none"></i>
                                                        <span class="d-none d-sm-block text-white">Modifier</span>
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <form id="deleteForm" method="POST">
                @csrf
                @method('DELETE')

            </form>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
@endsection

@section('scripts')

    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="{{ asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('dist/js/vendors.js') }}"></script>



    <script>
        FilePond.create(document.querySelector(".multiple-files-filepond"), {
            credits: null,
            allowImagePreview: true,
            allowImageFilter: false,
            allowImageExifOrientation: false,
            allowMultiple: false,
            required: false,
            storeAsFile: true,

            labelIdle: `<span class="text-primary">Choisir une image ou <span class="filepond--label-action text-primary" >Browse</span></span>`,
        });

        function openModal(path, id) {
            var route = "{{ route('fichiers.update', 5) }}";
            route = route.slice(0, route.length - 2) + "/" + id

            $('#edit').modal('show');
            const options = {
                credits: null,
                allowImagePreview: true,
                allowImageFilter: false,
                allowImageExifOrientation: false,
                allowMultiple: false,
                required: false,
                storeAsFile: true,

                labelIdle: `<span class="text-primary">Choisir une image ou <span class="filepond--label-action text-primary" >Browse</span></span>`,
                files: [{
                    source: "{{ route('home') }}/storage/fichiers/" + path,
                }]
            }
            FilePond.create(document.querySelector(".multiple-files-filepond-edit"), options);
            $('#edit form').attr('action', route);
        }

        function deleteItem(id) {
            var route = "{{ route('fichiers.delete', 5) }}";
            route = route.slice(0, route.length - 2) + "/" + id
            $('#deleteForm').attr('action', route);
            $('#deleteForm').submit();

        }
    </script>
@endsection
