@extends('welcome')
@section('title', 'Fournisseurs')
@section('styles')
    <link href="{{ asset('dist/css/hotspot/hotspot.css') }}" rel="stylesheet" />
    <link href="{{ asset('dist/css/hotspot/style.css') }}" rel="stylesheet" />
@endsection

@section('content')
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">Fournisseurs</h5>
                                @if (Auth::user()->role_id == 1)
                                    <button type="button" data-bs-toggle="modal" data-bs-target="#inlineForm"
                                        class="btn btn-primary">Ajouter</button>
                                @endif
                            </div>
                            <div class="table-responsive">
                                <table class='table table-striped' id="table1">
                                    <thead>
                                        <tr>
                                            <th scope="col">Fournisseur</th>
                                            <th scope="col">Email</th>
                                            <th scope="col">Adresse</th>
                                            <th scope="col">Numéro de Téléphone</th>
                                            <th scope="col">Matricule Fiscale</th>
                                            @if (Auth::user()->role_id == 1)
                                                <th id="actions" scope="col">Actions</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($clients as $client)
                                            <tr>
                                                <td>
                                                    <div class="col-12 d-flex flex-row p-2 justify-content-start">
                                                        <div class="avatar avatar-sm">
                                                            @if ($client->image)
                                                                <img src=" {{ asset('/storage/clients/' . $client->image) }}"
                                                                    alt="">
                                                            @else
                                                                <img src="{{ asset('static/1.jpg') }} " alt="">
                                                            @endif
                                                        </div>
                                                        <div class="mx-3 d-flex justify-content-center align-items-center">
                                                            {{ $client->name }} </div>
                                                    </div>
                                                </td>
                                                <td>{{ $client->email }}</td>
                                                <td>{{ $client->address }}</td>
                                                <td>{{ $client->tel }}</td>
                                                <td>{{ $client->matFisc }}</td>
                                                @if (Auth::user()->role_id == 1)
                                                    <td>
                                                        <button id="{{ $client->id }}" class="btn btn-warning edit"
                                                            data-bs-toggle="modal" data-bs-target="#inlineFormEdit"><i
                                                                data-feather="edit"></i>Modifier</button>
                                                        <button onclick="deleteClient({{ $client->id }})"
                                                            class="btn btn-danger"><i
                                                                data-feather="trash"></i>Supprimer</button>
                                                    </td>
                                                @endif
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                                <form id="delete" method="POST">
                                    @method('DELETE')
                                    @csrf

                                </form>
                                <!--End Row-->

                                <div class="modal fade text-left " id="inlineForm" tabindex="-1" role="dialog"
                                    aria-labelledby="myModalLabel33" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-scrollable" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="myModalLabel33">Ajouter </h4>
                                                <button type="button" class="close" data-bs-dismiss="modal"
                                                    aria-label="Close">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
                                                        <path
                                                            d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                                    </svg>
                                                </button>
                                            </div>
                                            <form method="POST" action="{{ route('clients.store') }}"
                                                enctype="multipart/form-data" id="formmm">
                                                @csrf
                                                <div class="modal-body">
                                                    <label>Nom: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="name" class="form-control">
                                                    </div>


                                                    <label>Email: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="email" class="form-control">
                                                    </div>

                                                    <label>Numéro de Téléphone: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="tel" class="form-control">
                                                    </div>

                                                    <label>Aderesse: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="address" class="form-control">
                                                    </div>

                                                    <label>Matricule Fiscale: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="matFisc" class="form-control">
                                                    </div>
                                                    <input type="hidden" name="is_exempt_tva" value="0">
                                                    <input type="hidden" name="type" value="1">
                                                    <label>Image: </label>
                                                    <input type="file" name="image" class="multiple-files-filepond">
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light-secondary"
                                                        data-bs-dismiss="modal">
                                                        <i class="bx bx-x d-block d-sm-none"></i>
                                                        <span class="d-none d-sm-block">Annuler</span>
                                                    </button>
                                                    <button type="submit" class="btn btn-primary ml-1">
                                                        <i class="bx bx-check d-block d-sm-none"></i>
                                                        <span class="d-none d-sm-block text-white">Ajouter</span>
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade text-left " id="inlineFormEdit" tabindex="-1" role="dialog"
                                    aria-labelledby="myModalLabel33" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-scrollable" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title" id="myModalLabel33">Modifier </h4>
                                                <button type="button" class="close" data-bs-dismiss="modal"
                                                    aria-label="Close">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                                        fill="currentColor" class="bi bi-x-lg" viewBox="0 0 16 16">
                                                        <path
                                                            d="M2.146 2.854a.5.5 0 1 1 .708-.708L8 7.293l5.146-5.147a.5.5 0 0 1 .708.708L8.707 8l5.147 5.146a.5.5 0 0 1-.708.708L8 8.707l-5.146 5.147a.5.5 0 0 1-.708-.708L7.293 8 2.146 2.854Z" />
                                                    </svg>
                                                </button>
                                            </div>
                                            <form method="POST" id="formEdit" enctype="multipart/form-data">
                                                @csrf
                                                <div class="modal-body">
                                                    <label>Nom: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="name" class="form-control">
                                                    </div>


                                                    <label>Email: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="email" class="form-control">
                                                    </div>

                                                    <label>Numéro de Téléphone: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="tel" class="form-control">
                                                    </div>

                                                    <label>Aderesse: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="address" class="form-control">
                                                    </div>

                                                    <label>Matricule Fiscale: </label>
                                                    <div class="form-group">
                                                        <input type="text" name="matFisc" class="form-control">
                                                    </div>

                                                    <input type="hidden" name="is_exempt_tva" value="0">
                                                    <input type="hidden" name="type" value="1">
                                                    <label>Image: </label>
                                                    <input type="file" name="image" class="multiple-files-filepond">
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-light-secondary"
                                                        data-bs-dismiss="modal">
                                                        <i class="bx bx-x d-block d-sm-none"></i>
                                                        <span class="d-none d-sm-block">Annuler</span>
                                                    </button>
                                                    <button type="submit" class="btn btn-primary ml-1">
                                                        <i class="bx bx-check d-block d-sm-none"></i>
                                                        <span class="d-none d-sm-block text-white">Modifier</span>
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
@endsection

@section('scripts')





    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="{{ asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('dist/js/vendors.js') }}"></script>



    <script>
        FilePond.create(document.querySelector(".multiple-files-filepond"), {
            credits: null,
            allowImagePreview: true,
            allowImageFilter: false,
            allowImageExifOrientation: false,
            allowMultiple: false,
            required: false,
            storeAsFile: true,
            acceptedFileTypes: ["image/png", "image/jpg", "image/jpeg"],
            labelIdle: `<span class="text-primary">Choisir une image ou <span class="filepond--label-action text-primary" >Browse</span></span>`,
        });



        function deleteClient(id) {
            var form = document.getElementById('delete');
            let base = "{{ route('clients.destroy', '5') }}";
            base = base.replace('5', id);
            form.action = base;
            form.submit();
        }
        const filepondForm = document.getElementById('formEdit');
        const filepondImageInput = filepondForm.querySelector('input[name="image"]');
        const options = {
            credits: null,
            allowImagePreview: true,
            allowImageFilter: false,
            allowImageExifOrientation: false,
            allowMultiple: false,
            required: false,
            storeAsFile: true,
            acceptedFileTypes: ["image/png", "image/jpg", "image/jpeg"],
            labelIdle: `<span class="text-primary">Choisir une image ou <span class="filepond--label-action text-primary" >Browse</span></span>`,
        }
        let filepondInput = FilePond.create(filepondImageInput, options);
        document.addEventListener('click', function(event) {
            const target = event.target;
            if (target.classList.contains('edit')) {
                const form = document.getElementById('formEdit');
                const editButton = target;
                const id = editButton.id;
                let base = "{{ route('clients.show', '5') }}".replace('5', id);
                const nameInput = form.querySelector('input[name="name"]');
                const emailInput = form.querySelector('input[name="email"]');
                const addressInput = form.querySelector('input[name="address"]');
                const telInput = form.querySelector('input[name="tel"]');
                const matFiscInput = form.querySelector('input[name="matFisc"]');

                axios.get(base).then((response) => {
                    const client = response.data;
                    nameInput.value = client.name;
                    emailInput.value = client.email;
                    addressInput.value = client.address;
                    telInput.value = client.tel;
                    matFiscInput.value = client.matFisc;
                    FilePond.destroy(filepondInput);
                    FilePond.destroy(filepondImageInput);
                    filepondInput.destroy();
                    if (client.image) {
                        options.files = [{
                            source: "{{ route('home') }}/storage/clients/" + client.image,
                        }];

                    } else {
                        options.files = [];
                    }
                    FilePond.create(filepondImageInput, options);
                    form.action = "{{ route('clients.update', '5') }}".replace('5', id);
                });
            }
        });
    </script>
@endsection
