<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\BonDEntreesController;
use App\Http\Controllers\ClientsController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ModePaimentController;
use App\Http\Controllers\ProductsController;
use App\Http\Controllers\ReglementController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\StatementsController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/


Route::group(['middleware' => ['guest']], function () {
    Route::get('/login', [AuthController::class, 'index'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.perform');
});


Route::get('/logout', [AuthController::class, 'logout'])->name('logout.perform');
Route::group(['middleware' => ['auth']], function () {
    Route::get('/', [DashboardController::class, 'index'])->name('home');
    // Users 
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
    Route::get('/users/{id}', [UserController::class, 'show'])->name('users.show');
    Route::get('/profile', [UserController::class, 'show'])->name('users.profile');
    Route::post('/updatePassword/{id}', [UserController::class, 'updatePassword'])->name('users.updatePassword');
    Route::post('/users/{id}', [UserController::class, 'update'])->name('users.update');
    Route::delete('/users/{id}', [UserController::class, 'destroy'])->name('users.destroy');

    // Clients
    Route::get('/clients', [ClientsController::class, 'index'])->name('clients.index');
    Route::get('/fournisseurs', [ClientsController::class, 'fournisseur'])->name('fournisseur.index');
    Route::post('/clients', [ClientsController::class, 'store'])->name('clients.store');
    Route::get('/clients/{id}', [ClientsController::class, 'show'])->name('clients.show');
    Route::post('/clients/{id}', [ClientsController::class, 'update'])->name('clients.update');
    Route::delete('/clients/{id}', [ClientsController::class, 'destroy'])->name('clients.destroy');
    Route::get('/dashboard/clients', [DashboardController::class, 'clients'])->name('dashboard.clients');

    // Products
    Route::get('/products', [ProductsController::class, 'index'])->name('products.index');
    Route::post('/products', [ProductsController::class, 'store'])->name('products.store');
    Route::get('/products/{id}', [ProductsController::class, 'show'])->name('products.show');
    Route::post('/products/{id}', [ProductsController::class, 'update'])->name('products.update');
    Route::delete('/products/{id}', [ProductsController::class, 'destroy'])->name('products.destroy');

    // Bon d'entrees
    Route::get('/entrees', [BonDEntreesController::class, 'index'])->name('bon_d_entrees.index');
    Route::post('/entrees', [BonDEntreesController::class, 'store'])->name('bon_d_entrees.store');
    Route::get('/entree/{id?}', [BonDEntreesController::class, 'show'])->name('bon_d_entrees.show');
    Route::post('/entrees/{id}', [BonDEntreesController::class, 'update'])->name('bon_d_entrees.update');
    Route::delete('/entrees/{id}', [BonDEntreesController::class, 'destroy'])->name('bon_d_entrees.destroy');
    Route::get('/entreePDF/{bon}', [BonDEntreesController::class, 'getPDF'])->name('bon_d_entrees.getPDF');

    // Settings
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::post('/settings/{id}', [SettingsController::class, 'update'])->name('settings.update');

    // Statements
    Route::get('/invoices', [StatementsController::class, 'invoices'])->name('invoices.index');
    Route::get('/statements', [StatementsController::class, 'statements'])->name('statements.index');
    Route::get('/bons', [StatementsController::class, 'bons'])->name('bons.index');
    Route::post('/statements', [StatementsController::class, 'store'])->name('statements.store');
    Route::get('/invoice/{id?}', [StatementsController::class, 'show_invoice'])->name('invoices.show');
    Route::get('/statement/{id?}', [StatementsController::class, 'show_statement'])->name('statements.show');
    Route::get('/bon/{id?}', [StatementsController::class, 'show_bon'])->name('bons.show');
    Route::post('/statements/{id}', [StatementsController::class, 'update'])->name('statements.update');
    Route::delete('/statements/{id}', [StatementsController::class, 'destroy'])->name('statements.destroy');
    Route::get('/statementToInvoice/{id}', [StatementsController::class, 'toInvoice'])->name('statements.toInvoice');
    Route::get('/invoiceToBon/{id}', [StatementsController::class, 'toBon'])->name('statements.toBon');
    Route::get('/statementPDF/{statement}', [StatementsController::class, 'getPDF'])->name('statements.getPDF');
    Route::get('/delivery/{statement}', [StatementsController::class, 'getBonDeLivraison'])->name('statements.delivery');
    Route::post('/generateInvoice', [StatementsController::class, 'generateInvoiceFromMultiStatements'])->name('statements.generate');


    Route::get('/mode', [ModePaimentController::class, 'index'])->name('mode.index');
    Route::post('/mode/store', [ModePaimentController::class, 'store'])->name('mode.create');
    Route::post('/mode/update/{id}', [ModePaimentController::class, 'update'])->name('mode.update');
    Route::delete('/mode/{type}', [ModePaimentController::class, 'destroy'])->name('mode.delete');

    Route::post('/reglements/store', [ReglementController::class, 'store'])->name('reglements.store');
    Route::put('/reglements/update/{reglement}', [ReglementController::class, 'update'])->name('reglements.update');
    Route::delete('/reglements/{reglement}', [ReglementController::class, 'destroy'])->name('reglements.delete')->middleware('auth');
});
