<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('statement_items', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->unsignedBigInteger('statement_id')->nullable();
            $table->unsignedBigInteger('bon_de_livraisons_id')->nullable();
            $table->unsignedBigInteger('product_id');
            $table->decimal('quantity',15,3);
            $table->decimal('price',15,3);
            $table->decimal('discount',15,3);
            $table->decimal('tva',15,3);
            $table->timestamps();
            $table->foreign('statement_id')->references('id')->on('statements')->onUpdate('no action')->onDelete('no action');
            $table->foreign('bon_de_livraisons_id')->references('id')->on('bon_de_livraisons')->onUpdate('no action')->onDelete('no action');
            $table->foreign('product_id')->references('id')->on('products')->onUpdate('no action')->onDelete('no action');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statement_items');
    }
};
