@extends('welcome')
@section('title', 'Paramètres généraux')
@section('styles')
    <link href="{{ asset('dist/css/hotspot/hotspot.css') }}" rel="stylesheet" />
    <link href="{{ asset('dist/css/hotspot/style.css') }}" rel="stylesheet" />
    <style>
        .btnLoading {
            position: relative;
            background-color: #fff;
            color: #fff;
            border: 1px solid #ccc;
            border-radius: 50px;
            min-width: 200px;
            padding: 10px 0;
            font-size: 16px;
            font-weight: 700;
            letter-spacing: 1px;
            text-transform: uppercase;
            outline: none;
            box-shadow: 1px 1px 4px 1px transparent;

            transition: box-shadow 300ms ease-in-out;

            &:hover {
                box-shadow: 1px 1px 6px 1px #ccc;
            }

            &:before {
                position: absolute;
                z-index: 500;
                transform: rotateX(180deg);

                color: #fff;
                letter-spacing: 1px;
                opacity: 0;
                transition: none;
            }

            &:after {
                content: '';
                position: absolute;
                top: 0;
                left: 0;
                width: 20%;
                opacity: 0;
                height: 100%;
                overflow: hidden;
                background-color: #0EBEFF;
                border-radius: $50px;
                transition: width 10ms 600ms ease-in-out,
                    background-color 300ms ease-in,
                    opacity 250ms 300ms ease-in;
            }
        }


        .is-activeLoading {
            transform: rotateX(180deg);
            background-color: $#fff;
            box-shadow: 1px 1px 4px 1px transparent !important;

            transition: transform 300ms ease-in-out,
                background-color 300ms ease-in;

            &:after {
                opacity: 1;
                background-color: green;
                border-radius: 50px;
                width: 50%;

                transition: width 1s 0.5s ease-in-out,
                    background-color 300ms 300ms ease-in,
                    opacity 250ms 300ms ease-in;
            }

            &:before {
                opacity: 1;
                transition: opacity 250ms 1.5s ease-in;
            }
        }

        .is-activeHalfway {
            transform: rotateX(180deg);
            background-color: $#fff;
            box-shadow: 1px 1px 4px 1px transparent !important;

            transition: transform 300ms ease-in-out,
                background-color 300ms ease-in;

            &:after {
                opacity: 1;
                background-color: green;
                border-radius: 50px;
                width: 70%;

                transition: width 1s 0.5s ease-in-out,
                    background-color 300ms 300ms ease-in,
                    opacity 250ms 300ms ease-in;
            }

            &:before {
                opacity: 1;
                transition: opacity 250ms 1.5s ease-in;
            }
        }

        .is-activeAlmostDone {
            transform: rotateX(180deg);
            background-color: $#fff;
            box-shadow: 1px 1px 4px 1px transparent !important;

            transition: transform 300ms ease-in-out,
                background-color 300ms ease-in;

            &:after {
                opacity: 1;
                background-color: green;
                border-radius: 50px;
                width: 90%;

                transition: width 1s 0.5s ease-in-out,
                    background-color 300ms 300ms ease-in,
                    opacity 250ms 300ms ease-in;
            }

            &:before {
                opacity: 1;
                transition: opacity 250ms 1.5s ease-in;
            }
        }

        .is-activeDone {
            transform: rotateX(180deg);
            background-color: $#fff;
            box-shadow: 1px 1px 4px 1px transparent !important;

            transition: transform 300ms ease-in-out,
                background-color 300ms ease-in;

            &:after {
                opacity: 1;
                background-color: green;
                border-radius: 50px;
                width: 100%;

                transition: width 1s 0.5s ease-in-out,
                    background-color 300ms 300ms ease-in,
                    opacity 250ms 300ms ease-in;
            }

            &:before {
                opacity: 1;
                transition: opacity 250ms 1.5s ease-in;
            }
        }
    </style>
@endsection

@section('content')
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    @if (Auth::user()->role_id == 1)
                        <div class="card m-3">
                            <div class="card-body">
                                <div class="d-flex justify-content-between m-3">
                                    <h5 class="card-title">
                                        Synchornisation des articles
                                    </h5>
                                    <button id="synchronize" class="btn btn-primary">Synchroniser</button>
                                </div>
                            </div>
                        </div>
                    @endif
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">
                                    Paramètres généraux
                                </h5>
                                @if (Auth::user()->role_id == 1)
                                    <button type="button" id="edit" class="btn btn-primary">Modifier</button>
                                @endif
                            </div>
                            @if (Auth::user()->role_id == 1)
                                <div class="d-flex flex-wrap justify-content-start m-3">
                                    <form method="POST" action="{{ route('statements.destroy', 2) }}">
                                        @method('DELETE')
                                        @csrf
                                        <button class="btn btn-danger m-1">Supprimer Dernier Devis</button>
                                    </form>
                                    <form method="POST" action="{{ route('statements.destroy', 1) }}">
                                        @method('DELETE')
                                        @csrf
                                        <button class="btn btn-danger m-1">Supprimer Dernière Facture</button>
                                    </form>
                                    <form method="POST" action="{{ route('statements.destroy', 3) }}">
                                        @method('DELETE')
                                        @csrf
                                        <button class="btn btn-danger m-1">Supprimer Dernier Bon De Livraison</button>
                                    </form>
                                </div>
                            @endif
                            <form method="POST" id="form" enctype="multipart/form-data"
                                action="{{ route('settings.update', $bon->id) }}">
                                @csrf
                                <div class="form-body">
                                    <div class="row">
                                        <div class="form-group col-md-4">
                                            <label>Mot de passe par défaut:</label>
                                            <input disabled type="text" name="password" value="{{ $bon->password }}"
                                                class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Timbre Fiscal:</label>
                                            <input disabled type="number" step="0.001" name="tmbr"
                                                value="{{ $bon->tmbr }}" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Nom de Société:</label>
                                            <input disabled type="text" name="company" value="{{ $bon->company }}"
                                                class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Adresse:</label>
                                            <input disabled type="text" name="address" value="{{ $bon->address }}"
                                                class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Numéro de téléphone:</label>
                                            <input disabled type="text" name="phone" value="{{ $bon->phone }}"
                                                class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Email:</label>
                                            <input disabled type="text" name="email" value="{{ $bon->email }}"
                                                class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Matricule Fiscale:</label>
                                            <input disabled type="text" name="matFisc" value="{{ $bon->matFisc }}"
                                                class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>RIB:</label>
                                            <input disabled type="text" name="rib" value="{{ $bon->rib }}"
                                                class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Banque:</label>
                                            <input disabled type="text" name="bank" value="{{ $bon->bank }}"
                                                class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Agence:</label>
                                            <input disabled type="text" name="agency" value="{{ $bon->agency }}"
                                                class="form-control">
                                        </div>

                                        <div class="form-group col-md-4">
                                            <label></label>
                                            <div class="form-check">
                                                <label for="factimg">Imprimer Image Produit</label>
                                                <input disabled type="checkbox" name="factimg" id="factimg"
                                                    class="form-check-input"
                                                    @if ($bon->factimg) checked @endif>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label></label>
                                            <div class="form-check">
                                                <label for="qtezero">Gestion de stock</label>
                                                <input disabled type="checkbox" name="qtezero" id="qtezero"
                                                    class="form-check-input"
                                                    @if ($bon->qtezero) checked @endif>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Logo:</label>
                                            <input disabled type="file" class="form-control" name="logo">
                                        </div>
                                    </div>
                                    @if (Auth::user()->role_id == 1)
                                        <div class="modal-footer">
                                            <button type="submit" id="buttonConfirm" disabled
                                                class="btn btn-primary ml-1">
                                                <i class="bx bx-check d-block d-sm-none"></i>
                                                <span class=" text-white">Confirmer</span>
                                            </button>
                                        </div>
                                    @endif
                                </div>
                            </form>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
@endsection

@section('scripts')
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="{{ asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('dist/js/vendors.js') }}"></script>
    <script>
        const activeOptions = {
            credits: null,
            allowImagePreview: true,
            allowImageFilter: false,
            allowImageExifOrientation: false,
            allowMultiple: false,
            disabled: false,
            required: false,
            storeAsFile: true,
            acceptedFileTypes: ["image/png", "image/jpg", "image/jpeg"],
            labelIdle: `<span class="text-primary">Choisir une image ou <span class="filepond--label-action text-primary" >Browse</span></span>`,
        };
        const inactiveOptions = {
            credits: null,
            allowImagePreview: true,
            allowImageFilter: false,
            allowImageExifOrientation: false,
            allowMultiple: false,
            required: false,
            disabled: true,
            storeAsFile: true,
            acceptedFileTypes: ["image/png", "image/jpg", "image/jpeg"],
            labelIdle: `<span class="text-primary">Choisir une image ou <span class="filepond--label-action text-primary" >Browse</span></span>`,
        };
        @if ($bon && $bon->logo)
            activeOptions.files = [{
                source: "{{ asset('static/' . $bon->logo) }}",
            }];

            inactiveOptions.files = [{
                source: "{{ asset('static/' . $bon->logo) }}",
            }];
        @endif
        const pond = FilePond.create(document.querySelector('input[type="file"]'), inactiveOptions);


        const button = document.querySelector("#edit");
        const logoDiv = document.querySelector("#logoDiv");
        let isActive = false;
        button.addEventListener('click', () => {
            isActive = !isActive;
            if (isActive) {

                button.classList.remove('btn-primary');
                button.classList.add('btn-danger');
                button.innerHTML = 'Annuler';
                document.querySelectorAll('input').forEach(input => {
                    input.removeAttribute('disabled');
                });
                document.querySelector("#buttonConfirm").removeAttribute('disabled');
                document.querySelector('form').removeAttribute('disabled');
                pond.setOptions(activeOptions);
            } else {
                button.classList.remove('btn-danger');
                button.classList.add('btn-primary');
                button.innerHTML = 'Modifier';
                document.querySelectorAll('input').forEach(input => {
                    input.setAttribute('disabled', true);
                });

                document.querySelector("#buttonConfirm").setAttribute('disabled', true);
                document.querySelector('form').setAttribute('disabled', true);
                pond.setOptions(inactiveOptions);
            }
        })

        document.querySelector("#synchronize").addEventListener('click', () => {
            const overlay = document.createElement('div');
            overlay.id = 'overlay';
            overlay.style.position = 'fixed';
            overlay.style.top = '0';
            overlay.style.left = '0';
            overlay.style.width = '100%';
            overlay.style.height = '100%';
            overlay.style.backgroundColor = 'rgba(0, 0, 0, 0.5)';
            overlay.style.zIndex = '9999';
            overlay.style.display = 'flex';
            overlay.style.justifyContent = 'center';
            overlay.style.alignItems = 'center';
            const loadingButton = document.createElement('button');

            loadingButton.classList.add('btnLoading');
            overlay.append(loadingButton);
            document.body.appendChild(overlay);
            setTimeout(() => {
                loadingButton.classList.add('is-activeLoading');
            }, 1000);
            setTimeout(() => {
                loadingButton.classList.remove('is-activeLoading');
                loadingButton.classList.add('is-activeHalfway');
            }, 3000)

            setTimeout(() => {
                loadingButton.classList.remove('is-activeHalfway');
                loadingButton.classList.add('is-activeAlmostDone');
            }, 5000)

            setTimeout(() => {
                loadingButton.classList.remove('is-activeAlmostDone');
                loadingButton.classList.add('is-activeDone');
            }, 8000)



            axios.post("{{ route('products.synchronize') }}").then(response => {
                overlay.remove();
                if (response.status == 200) {
                    Toastify({
                        text: "Synchronisation terminée avec succès",
                        duration: 3000,
                        close: true,
                        gravity: "bottom",
                        position: "right",
                        backgroundColor: "#4fbe87",
                    }).showToast()

                } else {
                    Toastify({
                        text: "Erreur lors de la synchronization",
                        duration: 3000,
                        close: true,
                        gravity: "bottom",
                        position: "left",
                        backgroundColor: "red",
                    }).showToast()
                }
            }).catch(error => {
                loadingButton.classList.remove('is-activeLoading');
                overlay.remove();
                Toastify({
                    text: "Erreur lors de la synchronization",
                    duration: 3000,
                    close: true,
                    gravity: "bottom",
                    position: "left",
                    backgroundColor: "red",
                }).showToast()
            });
        });
    </script>
@endsection
