<?php $__env->startSection('title'); ?>
    <?php if($type == 1): ?>
        Factures
    <?php endif; ?>
    <?php if($type == 2): ?>
        Devis
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('dist/css/hotspot/hotspot.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dist/css/hotspot/style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">
                                    <?php if($type == 1): ?>
                                        Factures
                                    <?php endif; ?>
                                    <?php if($type == 2): ?>
                                        Devis
                                    <?php endif; ?>
                                </h5>
                                <button type="button" data-bs-toggle="modal" data-bs-target="#inlineForm"
                                    class="btn btn-primary" onclick="rediretionButton()">Ajouter</button>
                            </div>
                            <div class="table-responsive">
                                <table class='table table-striped' id="table1">
                                    <thead>
                                        <tr>
                                            <th scope="col">Date</th>
                                            <th scope="col">Référence</th>
                                            <th scope="col">Client</th>
                                            <th scope="col">THT</th>
                                            <th scope="col">TTC</th>
                                            <th scope="col">Quantité Générale</th>
                                            <th scope="col">PDF</th>
                                            <th scope="col">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $statements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($statement->created_at->format('d/m/Y')); ?></td>
                                                <td><?php echo e($statement->getId()); ?></td>
                                                <td><?php echo e($statement->client->name); ?></td>
                                                <td><?php echo e($statement->tht); ?></td>
                                                <td><?php echo e($statement->ttc); ?></td>
                                                <td><?php echo e($statement->gqte); ?></td>
                                                <td>
                                                    <a target="_blank" href="<?php echo e(route('statements.getPDF', $statement->id)); ?>"
                                                        class="btn btn-success">Imprimer</a>
                                                <td>
                                                    <?php if($type == 2): ?>
                                                        <a href="<?php echo e(route('statements.toInvoice', $statement->id)); ?>"
                                                            class="btn btn-primary"><i data-feather="eye"></i>Obtenir une Facture</a>
                                                    <?php endif; ?>
                                                    <?php if($type == 1): ?>
                                                        <a target="_blank" href="<?php echo e(route('statements.delivery', $statement->id)); ?>"
                                                            class="btn btn-primary">Obtenir un bon de livraison</a>
                                                    <?php endif; ?>
                                                    <button id="<?php echo e($statement->id); ?>" class="btn btn-warning edit"
                                                        data-bs-toggle="modal" data-bs-target="#inlineFormEdit"><i
                                                            data-feather="edit"></i>Modifier</button>
                                                    <button onclick="deleteClient(<?php echo e($statement->id); ?>)"
                                                        class="btn btn-danger"><i
                                                            data-feather="trash"></i>Supprimer</button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                                <form id="delete" method="POST">
                                    <?php echo method_field('DELETE'); ?>
                                    <?php echo csrf_field(); ?>

                                </form>
                                <!--End Row-->

                            </div>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('dist/js/simple-datatables/simple-datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('dist/js/vendors.js')); ?>"></script>



    <script>
        function deleteClient(id) {
            var form = document.getElementById('delete');
            let base = "<?php echo e(route('statements.destroy', '5')); ?>";
            base = base.replace('5', id);
            form.action = base;
            form.submit();
        }

        document.addEventListener('click', function(event) {
            const target = event.target;
            if (target.classList.contains('edit')) {
                const editButton = target;
                const id = editButton.id;
                <?php if($type == 1): ?>
                    window.location.href = "<?php echo e(route('invoices.show', '5')); ?>".replace('5', id);
                <?php endif; ?>
                <?php if($type == 2): ?>
                    window.location.href = "<?php echo e(route('statements.show', '5')); ?>".replace('5', id);
                <?php endif; ?>
            }
        })

        function rediretionButton() {
            <?php if($type == 1): ?>
                window.location.href = "<?php echo e(route('invoices.show')); ?>"
            <?php endif; ?>
            <?php if($type == 2): ?>
                window.location.href = "<?php echo e(route('statements.show')); ?>"
            <?php endif; ?>
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ahmed/facture/ap/resources/views/pages/statements/index.blade.php ENDPATH**/ ?>