@extends('welcome')
@section('title', 'Dashboard')
@section('styles')
    <link href="{{ asset('dist/css/hotspot/hotspot.css') }}" rel="stylesheet" />
    <link href="{{ asset('dist/css/hotspot/style.css') }}" rel="stylesheet" />
@endsection

@section('content')
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-6">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">Clients</h5>
                                <div class="col-4">
                                    <input type="month" lang="fr-CA" value="{{$year.'-'.$month}}" class="form-control" id="ClientDate">
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class='table table-striped' id="table1">
                                    <thead>
                                        <tr>
                                            <th scope="col">Client</th>

                                            <th scope="col">Matricule Fiscale</th>

                                            <th scope="col" id="number">Total</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tableClients">

                                    </tbody>
                                </table>


                                <!--End Row-->



                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">Articles</h5>

                            </div>
                            @if ($products->count() > 0)
                                <div id="carouselExample" class="carousel slide m-3">
                                    <div class="carousel-inner">
                                        <div class="carousel-item active">
                                            <div class="d-flex flex-column justify-content-center align-items-center">
                                                <div class="col-12 d-flex flex-column flex-row p-2 justify-content-center">
                                                    <div
                                                        class=" w-full d-flex flex-column justify-content-center align-items-center">
                                                        @if ($products[0]->image)
                                                            <img style="max-height: 100px; max-width: 100px; object-fit:contain; padding:3px; border-radius:10%"
                                                                src=" {{ asset('/storage/products/' . $products[0]->image) }}"
                                                                alt="">
                                                        @else
                                                            <img style="max-height: 100px; max-width: 100px; object-fit:contain; padding:3px; border-radius:10%"
                                                                src="{{ asset('static/2.png') }} " alt="">
                                                        @endif
                                                    </div>
                                                    <div class="mx-3 d-flex justify-content-center align-items-center">
                                                        <h5 class="card-title">{{ $products[0]->name }}</h5>
                                                    </div>
                                                    <div class="mx-3 d-flex justify-content-center align-items-center">
                                                        Vendu(e): {{ $products[0]->items->sum(function ($item) {
                                                            return $item->statement->type == 1 ? $item->quantity : 0;
                                                        }) }} fois </div>
                                                </div>
                                            </div>
                                        </div>
                                        @foreach ($products as $key => $product)
                                            @if ($key > 0)
                                                <div class="carousel-item">
                                                    <div
                                                        class="d-flex flex-column justify-content-center align-items-center">
                                                        <div
                                                            class="col-12 d-flex flex-column flex-row p-2 justify-content-center">
                                                            <div
                                                                class=" w-full d-flex flex-column justify-content-center align-items-center">
                                                                @if ($product->image)
                                                                    <img style="max-height: 100px; max-width: 100px; object-fit:contain; padding:3px; border-radius:10%"
                                                                        src=" {{ asset('/storage/products/' . $product->image) }}"
                                                                        alt="">
                                                                @else
                                                                    <img style="max-height: 100px; max-width: 100px; object-fit:contain; padding:3px; border-radius:10%"
                                                                        src="{{ asset('static/2.png') }} " alt="">
                                                                @endif
                                                            </div>
                                                            <div
                                                                class="mx-3 d-flex justify-content-center align-items-center">
                                                                <h5 class="card-title">{{ $product->name }}</h5>
                                                            </div>
                                                            <div
                                                                class="mx-3 d-flex justify-content-center align-items-center">
                                                                Vendu(e): {{ $product->items->sum(function ($item) {
                                                                    return $item->statement->type == 1 ? $item->quantity : 0;
                                                                }) }} fois
                                                                </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach


                                    </div>
                                    <button class="carousel-control-prev" type="button" data-bs-target="#carouselExample"
                                        data-bs-slide="prev">
                                        <span class="carousel-control-prev-icon bg-primary rounded-circle"
                                            aria-hidden="true"></span>
                                        <span class="visually-hidden">Previous</span>
                                    </button>
                                    <button class="carousel-control-next" type="button" data-bs-target="#carouselExample"
                                        data-bs-slide="next">
                                        <span class="carousel-control-next-icon bg-primary rounded-circle"
                                            aria-hidden="true"></span>
                                        <span class="visually-hidden">Next</span>
                                    </button>
                                </div>
                            @else
                                <div class="d-flex justify-content-center m-3">
                                    <h5 class="card-title">Pas de Produits</h5>

                                </div>
                            @endif
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
@endsection

@section('scripts')





    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="{{ asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js') }}"></script>
    <script src="{{ asset('dist/js/vendors.js') }}"></script>

    <script>
        function getClients(month, year) {
            let url = "{{ route('dashboard.clients') }}";
            if (month) {
                url = url + "?month=" + month;
            }
            if (year) {
                url = url + "&year=" + year;
            }
            if (year && !month) {
                url = url + "?year=" + year;
            }
            axios.get(url).then(response => {
                let clients = response.data;
                let tableClients = document.getElementById('tableClients');
                tableClients.innerHTML = '';
                
                clients.forEach(client => {
                    let tr = document.createElement('tr');
                    let somme = 0;
                    somme += client.statements.reduce((acc, statement) => acc + statement.ttc, 0);
                    let path = "{{ asset('') }}";
                    tr.innerHTML = `
                    <td>
                        <div class="col-12 d-flex flex-row p-2 justify-content-start">
                            <div class="avatar avatar-sm">
                                <img src="${client.image ? path+'storage/clients/' + client.image : path+'static/1.jpg'}" alt="">
                            </div>
                            <div class="mx-3 d-flex justify-content-center align-items-center">
                                ${client.name}
                            </div>
                        </div>
                    </td>
                    <td>${client.matFisc ? client.matFisc : ""}</td>
                    <td>${parseFloat(somme).toFixed(3)} DT</td>
`;
                    tableClients.appendChild(tr);
                });
            });
        }
        getClients(null, null);

        document.getElementById('ClientDate').addEventListener('change', function(e) {
            
            let date = new Date(e.target.value);
            let month = date.getMonth() + 1;
            let year = date.getFullYear();
            getClients(month, year);
        });

    </script>




@endsection
