<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Products extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    public function bon_d_entrees()
    {
        return $this->belongsToMany(BonDEntrees::class, 'product_bon_d_entree', 'product_id', 'bon_id')->withPivot('quantity')->withPivot('price');
    }

    public function items()
    {
        return $this->hasMany(StatementItems::class, 'product_id', 'id');
    }
    protected $fillable = [
        'name',
        'code',
        'product_id',
        'description',
        'image',
        'price',
        'quantity',
        'tva'
    ];
}