<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fichier extends Model
{
    use HasFactory;

    // Table name (optional if it follows Laravel naming conventions)
    protected $table = 'fichiers';

    // Disable timestamps if you don't want Laravel to manage them automatically
    public $timestamps = true;

    // Define fillable fields (if using mass assignment)
    protected $fillable = [
        'name',
        'path',
        'id_dossier',
    ];

    /**
     * A fichier belongs to a dossier.
     */
    public function dossier()
    {
        return $this->belongsTo(Dossier::class, 'id_dossier');
    }
}