<?php

namespace App\Http\Controllers;

use App\Models\Logs;
use App\Models\Reglement;
use Illuminate\Http\Request;

class ReglementController extends Controller
{
   
    public function store(Request $request)
    {
        $request->validate([
            'statement_id' => 'required',
            'montant' => 'required',
            'date' => 'required',
            'mode_paiment_id' => 'required',
            'statut' => 'required'
        ]);
        $reg = Reglement::create($request->all());
        
        return redirect()->back()->with('success', 'Reglement ajouté avec succès');
    }

    public function update(Request $request, Reglement $reglement)
    {
       
        $request->validate([
            'statement_id' => 'required',
            'montant' => 'required',
            'date' => 'required',
            'mode_paiment_id' => 'required',
            'statut' => 'required'
        ]);
        $reglement->update($request->all());
   
        return redirect()->back()->with('success', 'Reglement modifié avec succès');
    }

    public function destroy(Reglement $reglement)
    {
        $reglement->delete();
        return redirect()->back()->with('success', 'Reglement supprimé avec succès');
    }
}
