// Simple Datatable

function tables() {
    const today = new Date();
    const formattedDate =
        today.getFullYear() +
        "-" +
        (today.getMonth() + 1) +
        "-" +
        today.getDate();
    $(".table").each(function () {
        const jquery_datatable = $(this);
        jquery_datatable.DataTable({
            order: [],
            responsive: true,
            dom: "Bfrtip",
            lengthMenu: [10, 25, 50, 75, 100],
            buttons: [
                {
                    extend: "excel",
                    text: "Exporter Excel",
                    className: "btn btn-success",
                    filename: "Factures-" + formattedDate,
                    exportOptions: {
                        columns: "thead th:not(.noExport)",
                        format: {
                            body: function (data, row, column, node) {
                                var containsHTML = /<\/?[a-z][\s\S]*>/i.test(
                                    data
                                );
                                if (!containsHTML) {
                                    if ($(node).hasClass("montant")) {
                                        return parseFloat(data).toFixed(3);
                                    } else {
                                        return data
                                            .replace("⦾", "")
                                            .replace("⦿", "");
                                    }
                                } else {
                                    return data
                                        .replace(/<[^>]*>?/gm, "")
                                        .replace("⦾", "")
                                        .replace("⦿", "");
                                }
                            },
                            header: function (data, columnIdx) {
                                return data.split("<")[0];
                            },
                        },
                    },
                    customize: function (xlsx) {
                        // Calculate sum of columns with headers having the class "montant"
                        const indexes = [];
                        $("thead th.montant").each(function () {
                            indexes.push($(this).index());
                        });

                        // Add custom row with the sum
                        var sheet = xlsx.xl.worksheets["sheet1.xml"];
                        var r = "<row>";
                        for (
                            var i = 0;
                            i < $("thead th:not(.noExport)").length;
                            i++
                        )
                         {
                            if (indexes.includes(i)) {
                                var columnLetter = String.fromCharCode(65 + i);
                                var endIndex =
                                    jquery_datatable.DataTable().data().length +
                                    1;
                                const range = `${columnLetter}2:${columnLetter}${endIndex}`;
                                var formula = `FIXED(SUMPRODUCT(VALUE(REPLACE(${range}, FIND("DT", ${range}), 2, ""))), 3) &amp; " DT"`;
                                r += `<c t="n"><f>${formula}</f><v>${0}</v></c>`; // Assuming 0 as placeholder value
                            } else {
                                r += "<c/>";
                            }
                        }
                        r += "</row>";
                        $("row:last", sheet).after(r);
                    },
                },
            ],
            rowsGroup: [0, 1],
            initComplete: function () {
                const api = this.api();
                let table = this.api();
                api.columns().every(function () {
                    const column = this;
                    const title = column.header().textContent;

                    // Create input element
                    let input = document.createElement("input");
                    input.classList.add("form-control");
                    const br = document.createElement("br");
                    input.placeholder = title;

                    if (
                        column.header().innerHTML.toLowerCase() !== "actions" &&
                        column.header().id !== "actions"
                    ) {
                        if (column.header().id === "date") {
                            input.type = "date";
                        } else if (column.header().id === "number") {
                            input.type = "number";
                        } else if (column.header().id === "status") {
                            input = document.createElement("select");
                            input.classList.add("form-control");
                            input.style.borderRadius = "50px";
                            input.innerHTML = `
                                <option value="⦿ Payé">Payé</option>
                                <option value="⦾ Non Payé">Non Payé</option>
                            
                            `;
                        } else if (column.header().id === "tva") {
                            input = document.createElement("select");
                            input.classList.add("form-control");
                            input.style.borderRadius = "50px";
                            input.innerHTML = `
                                <option value="Oui">Oui</option>
                                <option value="Non">Non</option>
                            
                            `;
                        }

                        column.header().append(input);
                    }

                    // Event listener for user input
                    input.addEventListener("keyup", () => {
                        if (column.search() !== input.value) {
                            column.search(input.value).draw();
                        }
                    });

                    input.addEventListener("change", () => {
                        if (column.search() !== input.value) {
                            column.search(input.value).draw();
                        }
                    });

                    if (
                        jquery_datatable.hasClass("sum") &&
                        column.header().classList.contains("summable")
                    ) {
                        let sum = table
                            .column(column.index(), {
                                page: "current",
                                search: "applied",
                            })
                            .data()
                            .reduce(function (a, b) {
                                return parseFloat(a) + parseFloat(b);
                            }, 0);

                        $(column.footer()).html(sum.toFixed(3) + " DT");

                        table.on("draw", function () {
                            let sum = table
                                .column(column.index(), {
                                    page: "current",
                                    search: "applied",
                                })
                                .data()
                                .reduce(function (a, b) {
                                    return parseFloat(a) + parseFloat(b);
                                }, 0);

                            $(column.footer()).html(sum.toFixed(3) + " DT");
                        });
                    }
                });
            },
        });

        const setTableColor = () => {
            jquery_datatable
                .find(".dataTables_paginate .pagination")
                .addClass("pagination-primary");
        };

        setTableColor();
        jquery_datatable.on("draw.dt", setTableColor);
    });
}

tables();
