<?php $__env->startSection('title', 'Bons d\'entrées'); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('dist/css/hotspot/hotspot.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dist/css/hotspot/style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">Bons d'entrées</h5>
                                <button type="button" data-bs-toggle="modal" data-bs-target="#inlineForm"
                                    class="btn btn-primary" onclick="rediretionButton()">Ajouter</button>
                            </div>
                            <div class="table-responsive">
                                <table class='table table-striped' id="table1">
                                    <thead>
                                        <tr>
                                            <th id="date" scope="col">Date</th>
                                            <th scope="col">Référence</th>
                                            <th scope="col">Fournisseur</th>
                                            <th scope="col">Facture</th>
                                            <th scope="col">Commentaire</th>
                                            <th scope="col">Ajouté Par</th>
                                            <th scope="col">Modifié Par</th>
                                            <th scope="col" id="actions">Imprimer</th>
                                            <th scope="col">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $bons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($bon->date ? date_create($bon->date)->format('d-m-Y') : $bon->created_at->format('d-m-Y')); ?>

                                                </td>
                                                <td class="fw-bolder"><?php echo e($bon->reference); ?></td>
                                                <td><?php echo e($bon->fournisseurs->name); ?></td>
                                                <td><?php echo e($bon->facture); ?></td>
                                                <td><?php echo e($bon->comment); ?></td>
                                                <td><?php echo e($bon->user != null ? $bon->user->name . ' ' . $bon->user->lastName : ''); ?>

                                                </td>
                                                <td><?php echo e($bon->edit != null ? $bon->edit->name . ' ' . $bon->edit->lastName : ''); ?>

                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('bon_d_entrees.getPDF', $bon->id)); ?>" target="_blank"
                                                        class="btn btn-success"><i data-feather="printer"></i>Imprimer</a>
                                                <td>
                                                    <button id="<?php echo e($bon->id); ?>" class="btn btn-warning edit"
                                                        data-bs-toggle="modal" data-bs-target="#inlineFormEdit"><i
                                                            data-feather="edit"></i>Modifier</button>
                                                    <button onclick="deleteClient(<?php echo e($bon->id); ?>)"
                                                        class="btn btn-danger"><i
                                                            data-feather="trash"></i>Supprimer</button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                                <form id="delete" method="POST">
                                    <?php echo method_field('DELETE'); ?>
                                    <?php echo csrf_field(); ?>

                                </form>
                                <!--End Row-->

                            </div>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>





    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="<?php echo e(asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('dist/js/vendors.js')); ?>"></script>



    <script>
        function deleteClient(id) {
            var form = document.getElementById('delete');
            let base = "<?php echo e(route('bon_d_entrees.destroy', '5')); ?>";
            base = base.replace('5', id);
            form.action = base;
            form.submit();
        }

        document.addEventListener('click', function(event) {
            const target = event.target;
            if (target.classList.contains('edit')) {
                const editButton = target;
                const id = editButton.id;
                window.location.href = "<?php echo e(route('bon_d_entrees.show', '5')); ?>".replace('5', id);
            }
        })

        function rediretionButton() {
            window.location.href = "<?php echo e(route('bon_d_entrees.show')); ?>";
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mrtechtndd/www/fact/resources/views/pages/bon_d_entree/index.blade.php ENDPATH**/ ?>