<?php $__env->startSection('title', 'Bons d\'entrées'); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('dist/css/hotspot/hotspot.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dist/css/hotspot/style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">
                                    <?php if($bon): ?>
                                        Modifier
                                    <?php else: ?>
                                        Ajouter
                                    <?php endif; ?> Un Bon d'entrée
                                </h5>
                                <div>
                                    <h5 class="card-title">
                                        <?php if($bon): ?>
                                            Élaborée par: <?php echo e($bon->user->name); ?> <?php echo e($bon->user->lastName); ?>

                                        <?php else: ?>
                                            Élaborée par: <?php echo e(auth()->user()->name); ?> <?php echo e(auth()->user()->lastName); ?>

                                        <?php endif; ?>
                                    </h5>
                                    <h5 class="card-title">
                                        <?php if($bon): ?>
                                            <?php if($bon->edit_id != null): ?>
                                                Modifiée par: <?php echo e($bon->edit->name); ?> <?php echo e($bon->edit->lastName); ?>

                                            <?php else: ?>
                                                Modifiée par: <?php echo e(auth()->user()->name); ?> <?php echo e(auth()->user()->lastName); ?>

                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </h5>
                                </div>

                            </div>
                            <form method="POST" id="form" enctype="multipart/form-data"
                                action="<?php echo e(route('bon_d_entrees.store')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-body">
                                    <div class="row">
                                        <div class="row mb-5">
                                            <div class="form-group col-md-3">
                                                <label>Référence: </label>
                                                <input type="text" name="reference" disabled id="reference"
                                                    style="font-weight: bold;"
                                                    <?php if($bon): ?> value="<?php echo e($bon->reference); ?>" <?php else: ?> value="<?php echo e($ref); ?>" <?php endif; ?>
                                                    class="form-control">
                                            </div>

                                            <div class="form-group col-md-3" id="clientDiv">
                                                <label>Fournisseur: </label>
                                                <select name="fournisseur" class="form-control" id="selectClients">
                                                    <option value="0" <?php if($bon == null): ?> selected <?php endif; ?>
                                                        disabled>--</option>
                                                    <?php $__currentLoopData = $fournisseurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php if($bon && $bon->fournisseur == $client->id): ?> selected <?php endif; ?>
                                                            value="<?php echo e($client->id); ?>">
                                                            <?php echo e($client->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                            <div class="form-group col-md-3">
                                                <label>Facture: </label>
                                                <input type="text" name="facture"
                                                    <?php if($bon): ?> value="<?php echo e($bon->facture); ?>" <?php endif; ?>
                                                    class="form-control">
                                            </div>

                                            <div class="form-group col-md-3">
                                                <label>Date: </label>
                                                <input type="Date" name="date"
                                                    <?php if($bon): ?> value="<?php echo e($bon->date); ?>" <?php else: ?> value="<?php echo e($date); ?>" <?php endif; ?>
                                                    class="form-control">
                                            </div>
                                        </div>
                                        <input type="hidden" id="productsInput" name="produits">
                                        <div class="form-group col-12">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <label>Code Article</label>
                                                    <div class="form-group" id="codeForm">
                                                        <select id="codeProducts" class="codeProducts form-control">
                                                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($product->id); ?>"><?php echo e($product->code); ?>

                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3" id="searchForm">
                                                    <label>Articles</label>
                                                    <select id="selectProducts" class="selectProducts form-control">
                                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>

                                                <div class="col-md-3">
                                                    <label>Quantité</label>
                                                    <div class="form-group">
                                                        <input type="number" step="1" min="0"
                                                            id="quantitéProducts" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <label>Prix</label>
                                                    <div class="form-group">
                                                        <input type="number" step="0.001" min="0"
                                                            id="priceProducts" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-3 mb-5">
                                                    <label>&nbsp;</label> <!-- Placeholder for alignment -->
                                                    <div>
                                                        <button type="button" class="btn btn-primary w-full"
                                                            id="addProduct">Ajouter</button>
                                                    </div>
                                                    <div id="annuler"></div>
                                                </div>
                                            </div>

                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">Article</th>
                                                        <th scope="col">Code</th>
                                                        <th scope="col">Quantité</th>
                                                        <th scope="col">Prix</th>
                                                        <th scope="col">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="tbody">

                                                </tbody>
                                            </table>
                                        </div>

                                        <div class="form-group col-12">
                                            <label>Commentaire: </label>
                                            <textarea name="comment" class="form-control" id="" cols="30" rows="3"><?php echo e($bon ? $bon->comment : ''); ?></textarea>
                                        </div>


                                        <div class="modal-footer">

                                            <button type="submit" class="btn btn-primary ml-1">
                                                <i class="bx bx-check d-block d-sm-none"></i>
                                                <span class="text-white">
                                                    <?php if($bon): ?>
                                                        Modifier
                                                    <?php else: ?>
                                                        Ajouter
                                                    <?php endif; ?>
                                                </span>
                                            </button>
                                        </div>

                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="<?php echo e(asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('dist/js/vendors.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.15.2/js/selectize.min.js"
        integrity="sha512-IOebNkvA/HZjMM7MxL0NYeLYEalloZ8ckak+NDtOViP7oiYzG5vn6WVXyrJDiJPhl4yRdmNAG49iuLmhkUdVsQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        let productSelectize;
        let codeSelectize;
        $(document).ready(function() {
            const items = [];
            const options = {
                persist: false,
                maxItems: 1,
                items: items,
                valueField: 'id',
                plugins: ["restore_on_backspace", "clear_button"],
                onChange: function(value) {

                    codeSelectize[0].selectize.setValue(value);
                }

            }

            const codeOptions = {
                persist: false,
                maxItems: 1,
                items: items,
                valueField: 'id',
                plugins: ["restore_on_backspace", "clear_button"],
                onChange: function(value) {
                    productSelectize[0].selectize.setValue(value);
                }

            }



            productSelectize = $('#selectProducts').selectize(options);
            codeSelectize = $('#codeProducts').selectize(codeOptions);

            $('#searchForm').find('.clear').each(function(index, button) {
                button.click();
            });
            $('#codeForm').find('.clear').each(function(index, button) {
                button.click();
            });

            const clientOptions = {
                persist: false,
                maxItems: 1,
                items: items,
                valueField: 'id',
                plugins: ["restore_on_backspace", "clear_button"],
            }
            const clientSelectize = $('#selectClients').selectize(clientOptions);

            $('#clientDiv').find('.clear').each(function(index, button) {
                button.click();
            });
            <?php if($bon): ?>
                const fournisseur = <?php echo json_encode($bon->fournisseur, 15, 512) ?>;
                clientSelectize[0].selectize.setValue(fournisseur);
            <?php endif; ?>

        })
        <?php if($bon): ?>
            const products = <?php echo json_encode(
                $bon->products->map(function ($product) {
                    return ['id' => $product->id, 'quantité' => $product->pivot->quantity, 'price' => $product->pivot->price];
                })) ?>;
        <?php else: ?>
            const products = [];
        <?php endif; ?>
        let index = 0;
        let update = false;
        const originalProducts = <?php echo json_encode($products, 15, 512) ?>;
        const button = document.getElementById('addProduct');
        button.addEventListener('click', () => {
            if (update) {
                const select = document.getElementById('selectProducts');
                const quantité = document.getElementById('quantitéProducts');
                const price = document.getElementById('priceProducts');
                if (select.value == null || select.value == undefined || select.value == 0 || select.value == '') {
                    return;
                } else {
                    products[index] = {
                        id: select.value,
                        quantité: quantité.value,
                        price: price.value
                    };
                    select.value = 0;
                    quantité.value = 0;
                    price.value = 0;
                    $('#searchForm').find('.clear').each(function(index, button) {
                        button.click();
                    });
                    button.innerHTML = 'Ajouter';
                    update = false;
                    index = 0;
                    const annuler = document.getElementById('annuler');
                    annuler.innerHTML = '';
                    updateTable();
                }
            } else {
                const select = document.getElementById('selectProducts');
                const quantité = document.getElementById('quantitéProducts');
                const price = document.getElementById('priceProducts');

                if (select.value == null || select.value == undefined || select.value == 0 || select.value == '') {
                    return;
                } else {
                    products.push({
                        id: select.value,
                        quantité: quantité.value ? quantité.value : 0,
                        price: price.value ? price.value : 0
                    });
                    select.value = 0;
                    quantité.value = 0;
                    price.value = 0;
                    $('#searchForm').find('.clear').each(function(index, button) {
                        button.click();
                    });
                    updateTable();
                }
            }
        })

        function updateTable() {
            const tbody = document.getElementById('tbody');
            tbody.innerHTML = '';
            products.forEach((product) => {
                const p = originalProducts.find((p) => p.id == product.id);
                tbody.innerHTML += `
                    <tr id="p-${product.id}">
                        <td>${p.name}</td>
                        <td>${p.code == null ? "" : p.code}</td>
                        <td>${product.quantité}</td>
                        <td>${parseFloat(product.price).toFixed(3)}</td>
                        <td>
                            <button type="button" class="btn btn-warning" onclick="updateProduct('${product.id}','${product.quantité}','${product.price}')">Modifier</button>
                            <button type="button" class="btn btn-danger" onclick="removeProduct('p-${product.id}','${product.quantité}','${product.price}')">Supprimer</button>
                        </td>
                    </tr>
                `;
            })
        }
        updateTable();

        function removeProduct(id, quantité, prix) {
            const p_id = id.split('-')[1];
            const prod = products.find((p) => p.id == p_id && p.quantité == quantité && p.price == prix);
            const index = products.indexOf(prod);
            products.splice(index, 1);
            updateTable();
        }

        function updateProduct(id, quantity, prix) {
            const select = document.getElementById('selectProducts');
            const quantité = document.getElementById('quantitéProducts');
            const price = document.getElementById('priceProducts');
            const product = products.find((p) => p.id == id && p.quantité == quantity && p.price == prix);
            select.value = product.id;
            productSelectize[0].selectize.setValue(product.id);
            quantité.value = product.quantité;
            price.value = product.price;
            const annuler = document.getElementById('annuler');
            annuler.innerHTML = `<button type="button" class="btn btn-danger w-full" id="annulerProduct">Annuler</button>`;
            const annulerProduct = document.getElementById('annulerProduct');
            annulerProduct.addEventListener('click', () => {
                $('#searchForm').find('.clear').each(function(index, button) {
                    button.click();
                });
                select.value = 0;
                quantité.value = 0;
                price.value = 0;
                annuler.innerHTML = '';
                button.innerHTML = 'Ajouter';
                update = false;
                index = 0;
            })
            button.innerHTML = 'Modifier';
            update = true;
            index = products.indexOf(product);
        }


        const form = document.getElementById('form');
        form.addEventListener('submit', (e) => {
            e.preventDefault();
            <?php if($bon): ?>
                const action = `<?php echo e(route('bon_d_entrees.update', $bon->id)); ?>`;
                form.action = action;
            <?php endif; ?>
            const refInput = document.getElementById('reference');
            refInput.disabled = false;
            const productsInput = document.getElementById('productsInput');
            productsInput.value = JSON.stringify(products);
            form.submit();
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rjlbpor/www/resources/views/pages/bon_d_entree/show.blade.php ENDPATH**/ ?>