<?php $__env->startSection('title', 'Bons d\'entrées'); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('dist/css/hotspot/hotspot.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dist/css/hotspot/style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">
                                    <?php if($bon): ?>
                                        Modifier
                                    <?php else: ?>
                                        Ajouter
                                    <?php endif; ?> Un Bon d'entrée
                                </h5>

                            </div>
                            <form method="POST" id="form" enctype="multipart/form-data"
                                action="<?php echo e(route('bon_d_entrees.store')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-body">
                                    <div class="row">

                                        <div class="form-group col-4">
                                            <label>Référence: </label>
                                            <input type="text" name="reference"
                                                <?php if($bon): ?> value="<?php echo e($bon->reference); ?>" <?php endif; ?>
                                                class="form-control">
                                        </div>


                                        <div class="form-group col-4">
                                            <label>Fournisseur: </label>
                                            <input type="text" name="fournisseur"
                                                <?php if($bon): ?> value="<?php echo e($bon->fournisseur); ?>" <?php endif; ?>
                                                class="form-control">
                                        </div>

                                        <div class="form-group col-4">
                                            <label>Facture: </label>
                                            <input type="text" name="facture"
                                                <?php if($bon): ?> value="<?php echo e($bon->facture); ?>" <?php endif; ?>
                                                class="form-control">
                                        </div>
                                        <input type="hidden" id="productsInput" name="produits">
                                        <div class="form-group col-12">
                                            <div class="row">
                                                <div class="col-3">
                                                    <label>Produits</label>
                                                </div>
                                                <div class="col-3">
                                                    <label>Quantité</label>
                                                </div>
                                                <div class="col-3">
                                                    <label>Prix</label>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-3">
                                                    <select id="selectProducts" class="selectProducts form-control">
                                                        <option value="0" selected disabled>--</option>
                                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="form-group col-3">
                                                    <input type="number" step="1" min="0"
                                                        id="quantitéProducts" class="form-control">
                                                </div>
                                                <div class="form-group col-3">
                                                    <input type="number" step="0.001" min="0"
                                                        id="priceProducts" class="form-control">
                                                </div>
                                                <div class="d-flex col-2">
                                                    <div>
                                                        <button type="button" class="btn btn-primary mx-1"
                                                            id="addProduct">Ajouter</button>
                                                    </div>
                                                    <div id="annuler">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div>
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th scope="col">Produit</th>
                                                        <th scope="col">Quantité</th>
                                                        <th scope="col">Prix</th>
                                                        <th scope="col">Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="tbody">

                                                </tbody>
                                            </table>
                                        </div>



                                        <div class="modal-footer">

                                            <button type="submit" class="btn btn-primary ml-1">
                                                <i class="bx bx-check d-block d-sm-none"></i>
                                                <span class="d-none d-sm-block text-white">
                                                    <?php if($bon): ?>
                                                        Modifier
                                                    <?php else: ?>
                                                        Ajouter
                                                    <?php endif; ?>
                                                </span>
                                            </button>
                                        </div>

                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('dist/js/simple-datatables/simple-datatables.js')); ?>"></script>
    <script src="<?php echo e(asset('dist/js/vendors.js')); ?>"></script>
    <script>
        <?php if($bon): ?>
            const products = <?php echo json_encode(
                $bon->products->map(function ($product) {
                    return ['id' => $product->id, 'quantité' => $product->pivot->quantity, 'price' => $product->pivot->price];
                })) ?>;
        <?php else: ?>
            const products = [];
        <?php endif; ?>
        let index = 0;
        let update = false;
        const originalProducts = <?php echo json_encode($products, 15, 512) ?>;
        const button = document.getElementById('addProduct');
        button.addEventListener('click', () => {
            if (update) {
                const select = document.getElementById('selectProducts');
                const quantité = document.getElementById('quantitéProducts');
                const price = document.getElementById('priceProducts');
                products[index] = {
                    id: select.value,
                    quantité: quantité.value,
                    price: price.value
                };
                select.value = 0;
                quantité.value = 0;
                price.value = 0;
                button.innerHTML = 'Ajouter';
                update = false;
                index = 0;
                const annuler = document.getElementById('annuler');
            annuler.innerHTML = '';
                updateTable();
            } else {
                const select = document.getElementById('selectProducts');
                const quantité = document.getElementById('quantitéProducts');
                const price = document.getElementById('priceProducts');
                products.push({
                    id: select.value,
                    quantité: quantité.value,
                    price: price.value
                });
                select.value = 0;
                quantité.value = 0;
                price.value = 0;
                updateTable();
            }
        })

        function updateTable() {
            const tbody = document.getElementById('tbody');
            tbody.innerHTML = '';
            products.forEach((product) => {
                const p = originalProducts.find((p) => p.id == product.id);
                tbody.innerHTML += `
                    <tr id="p-${product.id}">
                        <td>${p.name}</td>
                        <td>${product.quantité}</td>
                        <td>${product.price}</td>
                        <td>
                            <button type="button" class="btn btn-warning" onclick="updateProduct('${product.id}','${product.quantité}','${product.price}')">Modifier</button>
                            <button type="button" class="btn btn-danger" onclick="removeProduct('p-${product.id}','${product.quantité}','${product.price}')">Supprimer</button>
                        </td>
                    </tr>
                `;
            })
        }
        updateTable();

        function removeProduct(id, quantité, prix) {
            const p_id = id.split('-')[1];
            const prod = products.find((p) => p.id == p_id && p.quantité == quantité && p.price == prix);
            const index = products.indexOf(prod);
            products.splice(index, 1);
            updateTable();
        }

        function updateProduct(id, quantity, prix) {
            const select = document.getElementById('selectProducts');
            const quantité = document.getElementById('quantitéProducts');
            const price = document.getElementById('priceProducts');
            const product = products.find((p) => p.id == id && p.quantité == quantity && p.price == prix);
            select.value = product.id;
            quantité.value = product.quantité;
            price.value = product.price;
            const annuler = document.getElementById('annuler');
            annuler.innerHTML = `<button type="button" class="btn btn-danger mx-1" id="annulerProduct">Annuler</button>`;
            const annulerProduct = document.getElementById('annulerProduct');
            annulerProduct.addEventListener('click', () => {
                select.value = 0;
                quantité.value = 0;
                price.value = 0;
                annuler.innerHTML = '';
                button.innerHTML = 'Ajouter';
                update = false;
                index = 0;
            })
            button.innerHTML = 'Modifier';
            update = true;
            index = products.indexOf(product);
        }


        const form = document.getElementById('form');
        form.addEventListener('submit', (e) => {
            e.preventDefault();
            <?php if($bon): ?>
                const action = `<?php echo e(route('bon_d_entrees.update', $bon->id)); ?>`;
                form.action = action;
                
            <?php endif; ?>
            const productsInput = document.getElementById('productsInput');
            productsInput.value = JSON.stringify(products);
            form.submit();
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ahmed/facture/ap/resources/views/pages/bon_d_entree/show.blade.php ENDPATH**/ ?>