<?php $__env->startSection('title', 'Paramètres généraux'); ?>
<?php $__env->startSection('styles'); ?>
    <link href="<?php echo e(asset('dist/css/hotspot/hotspot.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('dist/css/hotspot/style.css')); ?>" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content-wrapper">
        <div class="container-fluid">
            <div class="row mt-3">
                <div class="col-lg-12">
                    <div class="card m-3">
                        <div class="card-body">
                            <div class="d-flex justify-content-between m-3">
                                <h5 class="card-title">
                                    Paramètres généraux
                                </h5>
                                <button type="button" id="edit" class="btn btn-primary">Modifier</button>
                            </div>
                            <div class="d-flex flex-wrap justify-content-start m-3">
                                <form method="POST" action="<?php echo e(route('statements.destroy', 2)); ?>">
                                    <?php echo method_field('DELETE'); ?>
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-danger m-1">Supprimer Dernier Devis</button>
                                </form>
                                <form method="POST" action="<?php echo e(route('statements.destroy', 1)); ?>">
                                    <?php echo method_field('DELETE'); ?>
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-danger m-1">Supprimer Dernière Facture</button>
                                </form>
                                <form method="POST" action="<?php echo e(route('statements.destroy', 3)); ?>">
                                    <?php echo method_field('DELETE'); ?>
                                    <?php echo csrf_field(); ?>
                                    <button class="btn btn-danger m-1">Supprimer Dernier Bon De Livraison</button>
                                </form>
                            </div>
                            <form method="POST" id="form" enctype="multipart/form-data" action="<?php echo e(route('settings.update', $bon->id)); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="form-body">
                                    <div class="row">
                                        <div class="form-group col-md-4">
                                            <label>Mot de passe par défaut:</label>
                                            <input disabled type="text" name="password" value="<?php echo e($bon->password); ?>" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Timbre Fiscal:</label>
                                            <input disabled type="number" step="0.001" name="tmbr" value="<?php echo e($bon->tmbr); ?>" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Nom de Société:</label>
                                            <input disabled type="text" name="company" value="<?php echo e($bon->company); ?>" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Adresse:</label>
                                            <input disabled type="text" name="address" value="<?php echo e($bon->address); ?>" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Numéro de téléphone:</label>
                                            <input disabled type="text" name="phone" value="<?php echo e($bon->phone); ?>" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Email:</label>
                                            <input disabled type="text" name="email" value="<?php echo e($bon->email); ?>" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Matricule Fiscale:</label>
                                            <input disabled type="text" name="matFisc" value="<?php echo e($bon->matFisc); ?>" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>RIB:</label>
                                            <input disabled type="text" name="rib" value="<?php echo e($bon->rib); ?>" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Banque:</label>
                                            <input disabled type="text" name="bank" value="<?php echo e($bon->bank); ?>" class="form-control">
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label>Agence:</label>
                                            <input disabled type="text" name="agency" value="<?php echo e($bon->agency); ?>" class="form-control">
                                        </div>
                                        
                                        <div class="form-group col-md-4">
                                            <label></label>
                                            <div class="form-check">
                                                <label for="factimg">Imprimer Image Produit</label>
                                                <input disabled type="checkbox" name="factimg" id="factimg" class="form-check-input"
                                                    <?php if($bon->factimg): ?> checked <?php endif; ?>>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-4">
                                            <label></label>
                                            <div class="form-check">
                                                <label for="qtezero">Gestion de stock</label>
                                                <input disabled type="checkbox" name="qtezero" id="qtezero" class="form-check-input"
                                                    <?php if($bon->qtezero): ?> checked <?php endif; ?>>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Logo:</label>
                                            <input disabled type="file" class="form-control" name="logo">
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" id="buttonConfirm" disabled class="btn btn-primary ml-1">
                                            <i class="bx bx-check d-block d-sm-none"></i>
                                            <span class=" text-white">Confirmer</span>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>



            </div>
            <!--End Row-->



            <!--start overlay-->
            <div class="overlay toggle-menu"></div>
            <!--end overlay-->
        </div>
        <!-- End container-fluid-->
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.js"></script>
    <script src="<?php echo e(asset('dist/js/datatables.net-bs5/js/dataTables.bootstrap5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('dist/js/vendors.js')); ?>"></script>
    <script>
        const activeOptions = {
            credits: null,
            allowImagePreview: true,
            allowImageFilter: false,
            allowImageExifOrientation: false,
            allowMultiple: false,
            disabled: false,
            required: false,
            storeAsFile: true,
            acceptedFileTypes: ["image/png", "image/jpg", "image/jpeg"],
            labelIdle: `<span class="text-primary">Choisir une image ou <span class="filepond--label-action text-primary" >Browse</span></span>`,
        };
        const inactiveOptions = {
            credits: null,
            allowImagePreview: true,
            allowImageFilter: false,
            allowImageExifOrientation: false,
            allowMultiple: false,
            required: false,
            disabled: true,
            storeAsFile: true,
            acceptedFileTypes: ["image/png", "image/jpg", "image/jpeg"],
            labelIdle: `<span class="text-primary">Choisir une image ou <span class="filepond--label-action text-primary" >Browse</span></span>`,
        };
        <?php if($bon && $bon->logo): ?>
        activeOptions.files = [
            {
                source: "<?php echo e(asset('static/' . $bon->logo)); ?>",
            }
        ];

        inactiveOptions.files = [
            {
                source: "<?php echo e(asset('static/' . $bon->logo)); ?>",
            }
        ];

        <?php endif; ?>
        const pond = FilePond.create(document.querySelector('input[type="file"]'), inactiveOptions);
        
            
        const button = document.querySelector("#edit");
        const logoDiv = document.querySelector("#logoDiv");
        let isActive = false;
        button.addEventListener('click', () => {
            isActive = !isActive;
            if (isActive) {

                button.classList.remove('btn-primary');
                button.classList.add('btn-danger');
                button.innerHTML = 'Annuler';
                document.querySelectorAll('input').forEach(input => {
                    input.removeAttribute('disabled');
                });
                document.querySelector("#buttonConfirm").removeAttribute('disabled');
                document.querySelector('form').removeAttribute('disabled');
                pond.setOptions(activeOptions);
            } else {
                button.classList.remove('btn-danger');
                button.classList.add('btn-primary');
                button.innerHTML = 'Modifier';
                document.querySelectorAll('input').forEach(input => {
                    input.setAttribute('disabled', true);
                });

                document.querySelector("#buttonConfirm").setAttribute('disabled', true);
                document.querySelector('form').setAttribute('disabled', true);
                pond.setOptions(inactiveOptions);
            }
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rjlbpor/www/resources/views/pages/settings/index.blade.php ENDPATH**/ ?>