<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('reglements', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('statement_id')->nullable();
            
            $table->decimal('amount',15,3)->nullable();
            $table->unsignedBigInteger('mode_paiment_id');
            $table->integer("statut")->nullable();
            $table->timestamps();
            $table->foreign('statement_id')->references('id')->on('statements')->onUpdate('no action')->onDelete('no action');
            $table->foreign('mode_paiment_id')->references('id')->on('mode_paiments')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('statement_items');
    }
};
