<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StatementItems extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */

    public function statement(){
        return $this->belongsTo(Statements::class, 'statement_id','id');
    }

    public function product(){
        return $this->belongsTo(Products::class, 'product_id','id');
    }

    protected $fillable = [
        'name',
        'code',
        'statement_id',
        'product_id',
        'quantity',
        'price',
        'tva',
        'discount'
    ];
}
