<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Dossier extends Model
{
    use HasFactory;

    
    // Define fillable fields (if using mass assignment)
    protected $fillable = [
        'name',
    ];

    /**
     * A dossier has many fichiers.
     */
    public function fichiers()
    {
        return $this->hasMany(Fichier::class, 'id_dossier');
    }
}