<?php

namespace App\Http\Controllers;

use App\Models\Dossier;
use App\Models\Fichier;
use Illuminate\Http\Request;

class FichierController extends Controller
{
    /**
     * Display a listing of all fichiers with a view.
     */
    public function index($id)
    {
        $fichiers = Fichier::with('dossier')->where('id_dossier', $id)->get(); // Eager load dossier relationship
        $dossier = Dossier::findOrFail($id);
        return view('pages.fichiers.index', [
            'fichiers' => $fichiers,
            'dossier' => $dossier,
        ]); // Pass data to the view
    }

    /**
     * Store a newly created fichier in the database and redirect back.
     */
    public function store(Request $request)
    {
        
        $validated = $request->validate([
            'id_dossier' => 'required|exists:dossiers,id', // Ensure the dossier exists
        ]);
        if (request()->hasFile('path')) {
            $file = request()->file('path');
            $fileName =  $file->getClientOriginalName();
            if ($file->move(public_path() . '/storage/fichiers/', $fileName)) {
                $validated['path'] = $fileName;
            }
            Fichier::create($validated);
    
            return back()->with('success', 'Fichier créé avec succès'); // Redirect back with success message
        }
        else{
            return back()->with('error', 'Veuillez choisir un fichier'); // Redirect back with success message
        }

        // Create a new fichier
    }

    /**
     * Update the specified fichier in the database and redirect back.
     */
    public function update(Request $request, $id)
    {
        // Validate the request data
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'path' => 'required|string|max:255',
            'id_dossier' => 'required|exists:dossiers,id', // Ensure the dossier exists
        ]);

        // Find the fichier by ID
        $fichier = Fichier::findOrFail($id);

        // Update the fichier
        $fichier->update($validated);

        return back()->with('success', 'Fichier modifié avec succès'); // Redirect back with success message
    }

    /**
     * Remove the specified fichier from the database and redirect back.
     */
    public function delete($id)
    {
        // Find the fichier by ID
        $fichier = Fichier::findOrFail($id);

        // Delete the fichier
        $fichier->delete();

        return back()->with('success', 'Fichier supprimé avec succès'); // Redirect back with success message
    }
}
